/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import java.util.List;
import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.pd.structure.PDStructTreeNode;
import org.verapdf.pd.structure.PDStructureNameSpace;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.tools.TaggedPDFHelper;

public class PDStructElem
extends PDStructTreeNode {
    private Map<ASAtom, ASAtom> rootRoleMap;

    public PDStructElem(COSObject obj, Map<ASAtom, ASAtom> rootRoleMap) {
        super(obj);
        this.rootRoleMap = rootRoleMap;
    }

    public ASAtom getType() {
        return this.getObject().getNameKey(ASAtom.TYPE);
    }

    public COSName getCOSStructureType() {
        COSObject object = this.getKey(ASAtom.S);
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return (COSName)object.getDirectBase();
        }
        return null;
    }

    public COSString getLang() {
        COSObject object = this.getKey(ASAtom.LANG);
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return (COSString)object.getDirectBase();
        }
        return null;
    }

    public PDStructureNameSpace getNameSpace() {
        COSObject object = this.getKey(ASAtom.NS);
        if (object != null && object.getType() == COSObjType.COS_DICT) {
            return PDStructureNameSpace.createNameSpace(object);
        }
        return null;
    }

    public StructureType getStructureType() {
        return StructureType.createStructureType(this.getKey(ASAtom.S), this.getKey(ASAtom.NS));
    }

    public StructureType getDefaultStructureType() {
        return TaggedPDFHelper.getDefaultStructureType(this.getStructureType(), this.rootRoleMap);
    }

    @Override
    public List<PDStructElem> getChildren() {
        return TaggedPDFHelper.getStructElemChildren(this.getObject(), this.rootRoleMap);
    }
}

