/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.pd.font.truetype.TrueTypePredefined;

public class Encoding {
    private static final Logger LOGGER = Logger.getLogger(Encoding.class.getCanonicalName());
    private static final Encoding EMPTY = new Encoding(null);
    private static final String NOTDEF = ".notdef";
    private String[] predefinedEncoding;
    private Map<Integer, String> differences;

    public Encoding(ASAtom predefinedEncoding) {
        this.predefinedEncoding = predefinedEncoding == ASAtom.MAC_ROMAN_ENCODING ? TrueTypePredefined.MAC_ROMAN_ENCODING : (predefinedEncoding == ASAtom.MAC_EXPERT_ENCODING ? TrueTypePredefined.MAC_EXPERT_ENCODING : (predefinedEncoding == ASAtom.WIN_ANSI_ENCODING ? TrueTypePredefined.WIN_ANSI_ENCODING : new String[0]));
    }

    public Encoding(ASAtom baseEncoding, Map<Integer, String> differences) {
        this(baseEncoding);
        this.differences = differences != null ? differences : new HashMap<Integer, String>();
    }

    public static Encoding empty() {
        return EMPTY;
    }

    public String getName(int code) {
        if (code >= 0) {
            if (this.differences == null) {
                if (code < this.predefinedEncoding.length) {
                    return this.predefinedEncoding[code];
                }
                return this.predefinedEncoding.length != 0 ? NOTDEF : null;
            }
            String diffRes = this.differences.get(code);
            if (diffRes == null && this.predefinedEncoding.length != 0) {
                diffRes = code < this.predefinedEncoding.length ? this.predefinedEncoding[code] : NOTDEF;
            }
            return diffRes;
        }
        LOGGER.log(Level.WARNING, "Invalid glyph code: " + code);
        return null;
    }

    public boolean containsCode(int code) {
        if (this.differences != null && this.differences.containsKey(code)) {
            return true;
        }
        return code < this.predefinedEncoding.length;
    }
}

