/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.encryption;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.encryption.AccessPermissions;
import org.verapdf.pd.encryption.PDCryptFilter;

public class PDEncryption
extends PDObject {
    private static final boolean DEFAULT_ENCRYPT_METADATA = true;
    private static final int DEFAULT_LENGTH = 40;
    private static final int DEFAULT_V = 0;
    private Map<ASAtom, PDCryptFilter> cryptFilters;

    public PDEncryption(COSObject obj) {
        super(obj);
        this.cryptFilters = this.getCryptFilters();
    }

    public PDEncryption() {
    }

    public ASAtom getFilter() {
        return this.getNameKey(ASAtom.FILTER);
    }

    public ASAtom getSubFilter() {
        return this.getNameKey(ASAtom.SUB_FILTER);
    }

    public AccessPermissions getUserPermissions() {
        Long p = this.getP();
        return p == null ? null : AccessPermissions.getUserPermissions(p.intValue());
    }

    public int getV() {
        return this.getIntWithDefault(ASAtom.V, 0);
    }

    public int getLength() {
        return this.getIntWithDefault(ASAtom.LENGTH, 40);
    }

    public Long getR() {
        return this.getIntegerKey(ASAtom.R);
    }

    public COSString getO() {
        return this.getCOSString(ASAtom.O);
    }

    public COSString getU() {
        return this.getCOSString(ASAtom.U);
    }

    public Long getP() {
        return this.getIntegerKey(ASAtom.P);
    }

    public COSString getOE() {
        return this.getCOSString(ASAtom.OE);
    }

    public COSString getUE() {
        return this.getCOSString(ASAtom.UE);
    }

    public boolean isEncryptMetadata() {
        COSObject encryptMetadata = this.getKey(ASAtom.ENCRYPT_META_DATA);
        if (encryptMetadata != null && encryptMetadata.getType() == COSObjType.COS_BOOLEAN) {
            return encryptMetadata.getDirectBase().getBoolean();
        }
        return true;
    }

    public PDCryptFilter getStandardCryptFilter() {
        return this.getCryptFilter(ASAtom.STD_CF);
    }

    public PDCryptFilter getCryptFilter(ASAtom cfName) {
        return this.cryptFilters.get(cfName);
    }

    private Map<ASAtom, PDCryptFilter> getCryptFilters() {
        HashMap<ASAtom, PDCryptFilter> res = new HashMap<ASAtom, PDCryptFilter>();
        COSObject cf = this.getKey(ASAtom.CF);
        if (cf == null || cf.getType() != COSObjType.COS_DICT) {
            return res;
        }
        Set<ASAtom> filters = cf.getKeySet();
        for (ASAtom filterName : filters) {
            res.put(filterName, new PDCryptFilter(cf.getKey(filterName)));
        }
        return res;
    }

    private COSString getCOSString(ASAtom key) {
        COSObject o = this.getKey(key);
        if (o != null && o.getType() == COSObjType.COS_STRING) {
            return (COSString)o.getDirectBase();
        }
        return null;
    }

    private int getIntWithDefault(ASAtom key, int defaultValue) {
        Long res = this.getIntegerKey(key);
        if (res != null) {
            return res.intValue();
        }
        return defaultValue;
    }
}

