/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;

public class COSEmbeddedFileDict {
    private final COSDictionary dictionary;
    private static final List<ASAtom> DEFINED_FILE_KEYS = new ArrayList<ASAtom>();

    public COSEmbeddedFileDict(COSDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public List<COSStream> getEmbeddedFileStreams() {
        ArrayList<COSStream> res = new ArrayList<COSStream>();
        for (ASAtom fileKey : DEFINED_FILE_KEYS) {
            COSObject fileStream = this.dictionary.getKey(fileKey);
            if (fileStream.empty() || fileStream.getType() != COSObjType.COS_STREAM) continue;
            res.add((COSStream)fileStream.getDirectBase());
        }
        return Collections.unmodifiableList(res);
    }

    static {
        DEFINED_FILE_KEYS.add(ASAtom.F);
        DEFINED_FILE_KEYS.add(ASAtom.UF);
        DEFINED_FILE_KEYS.add(ASAtom.DOS);
        DEFINED_FILE_KEYS.add(ASAtom.MAC);
        DEFINED_FILE_KEYS.add(ASAtom.UNIX);
    }
}

