/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core.matching.impl;

import java.util.List;
import org.unitils.mock.Mock;
import org.unitils.mock.argumentmatcher.ArgumentMatcher;
import org.unitils.mock.core.BehaviorDefiningInvocation;
import org.unitils.mock.core.MockFactory;
import org.unitils.mock.core.Scenario;
import org.unitils.mock.core.matching.MatchingInvocationHandler;
import org.unitils.mock.core.proxy.ProxyInvocation;

public abstract class AssertVerifyingMatchingInvocationHandler
implements MatchingInvocationHandler {
    protected Scenario scenario;
    protected MockFactory mockFactory;

    public AssertVerifyingMatchingInvocationHandler(Scenario scenario, MockFactory mockFactory) {
        this.scenario = scenario;
        this.mockFactory = mockFactory;
    }

    @Override
    public Object handleInvocation(ProxyInvocation proxyInvocation, List<ArgumentMatcher> argumentMatchers) throws Throwable {
        BehaviorDefiningInvocation behaviorDefiningInvocation = new BehaviorDefiningInvocation(proxyInvocation, null, argumentMatchers);
        this.performAssertion(this.scenario, behaviorDefiningInvocation);
        return this.createChainedMock(proxyInvocation);
    }

    protected Object createChainedMock(ProxyInvocation proxyInvocation) {
        Class<?> innerMockType = proxyInvocation.getMethod().getReturnType();
        String innerMockName = proxyInvocation.getMockName() + "##chained##" + proxyInvocation.getMethod().getName();
        Mock<?> mock = this.mockFactory.createChainedMock(innerMockName, innerMockType);
        if (mock == null) {
            return null;
        }
        return this.performChainedAssertion(mock);
    }

    protected abstract void performAssertion(Scenario var1, BehaviorDefiningInvocation var2);

    protected abstract Object performChainedAssertion(Mock<?> var1);
}

