/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core;

import java.util.List;
import org.unitils.mock.argumentmatcher.ArgumentMatcher;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.mockbehavior.MockBehavior;

public class BehaviorDefiningInvocation
extends ProxyInvocation {
    protected List<ArgumentMatcher> argumentMatchers;
    protected MockBehavior mockBehavior;

    public BehaviorDefiningInvocation(ProxyInvocation proxyInvocation, MockBehavior mockBehavior, List<ArgumentMatcher> argumentMatchers) {
        super(proxyInvocation);
        this.argumentMatchers = argumentMatchers;
        this.mockBehavior = mockBehavior;
    }

    public MockBehavior getMockBehavior() {
        return this.mockBehavior;
    }

    public void setMockBehavior(MockBehavior mockBehavior) {
        this.mockBehavior = mockBehavior;
    }

    public int matches(ProxyInvocation proxyInvocation) {
        if (!this.getMethod().equals(proxyInvocation.getMethod())) {
            return -1;
        }
        List<Object> arguments = proxyInvocation.getArguments();
        List<Object> argumentsAtInvocationTime = proxyInvocation.getArgumentsAtInvocationTime();
        if (arguments.size() != this.argumentMatchers.size()) {
            return -1;
        }
        int matchingScore = 0;
        for (int i = 0; i < arguments.size(); ++i) {
            Object argument = arguments.get(i);
            Object argumentAtInvocationTime = argumentsAtInvocationTime.get(i);
            ArgumentMatcher.MatchResult matchResult = this.argumentMatchers.get(i).matches(argument, argumentAtInvocationTime);
            if (matchResult == ArgumentMatcher.MatchResult.NO_MATCH) {
                return -1;
            }
            matchingScore += matchResult.getScore();
        }
        return matchingScore;
    }
}

