/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.dialect;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.spring5.expression.SPELVariableExpressionEvaluator;
import org.thymeleaf.spring5.expression.SpringStandardConversionService;
import org.thymeleaf.spring5.expression.SpringStandardExpressionObjectFactory;
import org.thymeleaf.spring5.processor.SpringActionTagProcessor;
import org.thymeleaf.spring5.processor.SpringErrorClassTagProcessor;
import org.thymeleaf.spring5.processor.SpringErrorsTagProcessor;
import org.thymeleaf.spring5.processor.SpringHrefTagProcessor;
import org.thymeleaf.spring5.processor.SpringInputCheckboxFieldTagProcessor;
import org.thymeleaf.spring5.processor.SpringInputFileFieldTagProcessor;
import org.thymeleaf.spring5.processor.SpringInputGeneralFieldTagProcessor;
import org.thymeleaf.spring5.processor.SpringInputPasswordFieldTagProcessor;
import org.thymeleaf.spring5.processor.SpringInputRadioFieldTagProcessor;
import org.thymeleaf.spring5.processor.SpringMethodTagProcessor;
import org.thymeleaf.spring5.processor.SpringObjectTagProcessor;
import org.thymeleaf.spring5.processor.SpringOptionFieldTagProcessor;
import org.thymeleaf.spring5.processor.SpringOptionInSelectFieldTagProcessor;
import org.thymeleaf.spring5.processor.SpringSelectFieldTagProcessor;
import org.thymeleaf.spring5.processor.SpringSrcTagProcessor;
import org.thymeleaf.spring5.processor.SpringTextareaFieldTagProcessor;
import org.thymeleaf.spring5.processor.SpringValueTagProcessor;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.processor.StandardActionTagProcessor;
import org.thymeleaf.standard.processor.StandardHrefTagProcessor;
import org.thymeleaf.standard.processor.StandardMethodTagProcessor;
import org.thymeleaf.standard.processor.StandardObjectTagProcessor;
import org.thymeleaf.standard.processor.StandardSrcTagProcessor;
import org.thymeleaf.standard.processor.StandardValueTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

public class SpringStandardDialect
extends StandardDialect {
    public static final String NAME = "SpringStandard";
    public static final String PREFIX = "th";
    public static final int PROCESSOR_PRECEDENCE = 1000;
    private boolean enableSpringELCompiler = false;
    private IExpressionObjectFactory expressionObjectFactory = null;
    private IStandardConversionService conversionService = null;

    public SpringStandardDialect() {
        super(NAME, PREFIX, 1000);
    }

    public boolean getEnableSpringELCompiler() {
        return this.enableSpringELCompiler;
    }

    public void setEnableSpringELCompiler(boolean enableSpringELCompiler) {
        this.enableSpringELCompiler = enableSpringELCompiler;
    }

    public IStandardVariableExpressionEvaluator getVariableExpressionEvaluator() {
        return SPELVariableExpressionEvaluator.INSTANCE;
    }

    public IStandardConversionService getConversionService() {
        if (this.conversionService == null) {
            this.conversionService = new SpringStandardConversionService();
        }
        return this.conversionService;
    }

    public IExpressionObjectFactory getExpressionObjectFactory() {
        if (this.expressionObjectFactory == null) {
            this.expressionObjectFactory = new SpringStandardExpressionObjectFactory();
        }
        return this.expressionObjectFactory;
    }

    public Set<IProcessor> getProcessors(String dialectPrefix) {
        return SpringStandardDialect.createSpringStandardProcessorsSet(dialectPrefix);
    }

    public Map<String, Object> getExecutionAttributes() {
        Map executionAttributes = super.getExecutionAttributes();
        executionAttributes.put("EnableSpringELCompiler", this.getEnableSpringELCompiler());
        return executionAttributes;
    }

    public static Set<IProcessor> createSpringStandardProcessorsSet(String dialectPrefix) {
        Set standardProcessors = StandardDialect.createStandardProcessorsSet((String)dialectPrefix);
        LinkedHashSet<IProcessor> processors = new LinkedHashSet<IProcessor>(40);
        for (IProcessor standardProcessor : standardProcessors) {
            if (!(standardProcessor instanceof StandardObjectTagProcessor || standardProcessor instanceof StandardActionTagProcessor || standardProcessor instanceof StandardHrefTagProcessor || standardProcessor instanceof StandardMethodTagProcessor || standardProcessor instanceof StandardSrcTagProcessor || standardProcessor instanceof StandardValueTagProcessor)) {
                processors.add(standardProcessor);
                continue;
            }
            if (standardProcessor.getTemplateMode() == TemplateMode.HTML) continue;
            processors.add(standardProcessor);
        }
        processors.add((IProcessor)new SpringActionTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringHrefTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringMethodTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringSrcTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringValueTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringObjectTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringErrorsTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputGeneralFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputPasswordFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputCheckboxFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputRadioFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputFileFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringSelectFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringOptionInSelectFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringOptionFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringTextareaFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringErrorClassTagProcessor(dialectPrefix));
        return processors;
    }
}

