/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.utils;

import java.util.Base64;

public class ROT13Utils {
    public static String rot13(String str) {
        StringBuilder result = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c >= 'a' && c <= 'z') {
                c = (char)((c - 97 + 13) % 26 + 97);
            } else if (c >= 'A' && c <= 'Z') {
                c = (char)((c - 65 + 13) % 26 + 65);
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String encrypt(String str) {
        try {
            String encode = ROT13Utils.encode(str);
            return ROT13Utils.rot13(encode);
        }
        catch (Exception e) {
            return str;
        }
    }

    public static String decrypt(String encrypted) {
        try {
            String encrypt = ROT13Utils.rot13(encrypted.replaceFirst("^\"", "").replaceAll("\"$", ""));
            return ROT13Utils.decode(encrypt);
        }
        catch (Exception e) {
            return encrypted;
        }
    }

    public static String encode(String input) {
        byte[] encodedBytes = Base64.getEncoder().encode(input.getBytes());
        return new String(encodedBytes);
    }

    public static String decode(String encodedString) {
        byte[] decodedBytes = Base64.getDecoder().decode(encodedString.getBytes());
        return new String(decodedBytes);
    }
}

