/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db.dialect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.ssssssss.magicapi.modules.db.BoundSql;

public interface Dialect {
    public static final Pattern REPLACE_ORDER_BY = Pattern.compile("\\s+order\\s+by\\s+[^,\\s]+(\\s+asc|\\s+desc)?(\\s*,\\s*[^,\\s]+(\\s+asc|\\s+desc)?)*\\s*$", 10);

    default public boolean match(String jdbcUrl) {
        return false;
    }

    default public boolean match(Connection connection) throws SQLException {
        return this.match(connection.getMetaData().getURL());
    }

    default public String getCountSql(String sql) {
        return "select count(1) from ( \n" + REPLACE_ORDER_BY.matcher(sql).replaceAll("") + "\n ) count_";
    }

    public String getPageSql(String var1, BoundSql var2, long var3, long var5);
}

