/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.validation;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.xml.JaxpVersion;
import org.springframework.xml.validation.Jaxp13ValidatorFactory;
import org.springframework.xml.validation.Jaxp15ValidatorFactory;
import org.springframework.xml.validation.XmlValidator;

public abstract class XmlValidatorFactory {
    private static final Log logger = LogFactory.getLog(XmlValidatorFactory.class);
    public static final String SCHEMA_W3C_XML = "http://www.w3.org/2001/XMLSchema";
    public static final String SCHEMA_RELAX_NG = "http://relaxng.org/ns/structure/1.0";

    public static XmlValidator createValidator(Resource schemaResource, String schemaLanguage) throws IOException {
        return XmlValidatorFactory.createValidator(new Resource[]{schemaResource}, schemaLanguage);
    }

    public static XmlValidator createValidator(Resource[] schemaResources, String schemaLanguage) throws IOException {
        Assert.notEmpty((Object[])schemaResources, (String)"No resources given");
        Assert.hasLength((String)schemaLanguage, (String)"No schema language provided");
        Assert.isTrue((SCHEMA_W3C_XML.equals(schemaLanguage) || SCHEMA_RELAX_NG.equals(schemaLanguage) ? 1 : 0) != 0, (String)("Invalid schema language: " + schemaLanguage));
        Assert.noNullElements((Object[])schemaResources, (String)"No null schemaResources allowed");
        for (Resource schemaResource : schemaResources) {
            Assert.isTrue((boolean)schemaResource.exists(), (String)("schema [" + String.valueOf(schemaResource) + "] does not exist"));
        }
        if (JaxpVersion.getJaxpVersion() >= 5) {
            logger.trace((Object)"Creating JAXP 1.5 XmlValidator");
            return Jaxp15ValidatorFactory.createValidator(schemaResources, schemaLanguage);
        }
        if (JaxpVersion.getJaxpVersion() >= 3) {
            logger.trace((Object)"Creating JAXP 1.3 XmlValidator");
            return Jaxp13ValidatorFactory.createValidator(schemaResources, schemaLanguage);
        }
        throw new IllegalStateException("Could not locate JAXP 1.3.");
    }
}

