/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContextManager {
    private static final String[] DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES = new String[]{"org.springframework.test.context.support.DependencyInjectionTestExecutionListener", "org.springframework.test.context.support.DirtiesContextTestExecutionListener", "org.springframework.test.context.transaction.TransactionalTestExecutionListener"};
    private static final Log logger = LogFactory.getLog(TestContextManager.class);
    static final ContextCache contextCache = new ContextCache();
    private final TestContext testContext;
    private final List<TestExecutionListener> testExecutionListeners = new ArrayList<TestExecutionListener>();

    public TestContextManager(Class<?> testClass) {
        this.testContext = new TestContext(testClass, contextCache);
        this.registerTestExecutionListeners(this.retrieveTestExecutionListeners(testClass));
    }

    protected final TestContext getTestContext() {
        return this.testContext;
    }

    public void registerTestExecutionListeners(TestExecutionListener ... testExecutionListeners) {
        for (TestExecutionListener listener : testExecutionListeners) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Registering TestExecutionListener [" + listener + "]"));
            }
            this.testExecutionListeners.add(listener);
        }
    }

    public final List<TestExecutionListener> getTestExecutionListeners() {
        return Collections.unmodifiableList(this.testExecutionListeners);
    }

    private TestExecutionListener[] retrieveTestExecutionListeners(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        Class<TestExecutionListeners> annotationType = TestExecutionListeners.class;
        ArrayList<Class<? extends TestExecutionListener>> classesList = new ArrayList<Class<? extends TestExecutionListener>>();
        Class declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
        boolean defaultListeners = false;
        if (declaringClass == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("@TestExecutionListeners is not present for class [" + clazz + "]: using defaults."));
            }
            classesList.addAll(this.getDefaultTestExecutionListenerClasses());
            defaultListeners = true;
        } else {
            while (declaringClass != null) {
                Class<? extends TestExecutionListener>[] classes;
                TestExecutionListeners testExecutionListeners = declaringClass.getAnnotation(annotationType);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Retrieved @TestExecutionListeners [" + testExecutionListeners + "] for declaring class [" + declaringClass + "]."));
                }
                if ((classes = testExecutionListeners.value()) != null) {
                    classesList.addAll(0, Arrays.asList(classes));
                }
                declaringClass = testExecutionListeners.inheritListeners() ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
            }
        }
        ArrayList<TestExecutionListener> listeners = new ArrayList<TestExecutionListener>(classesList.size());
        for (Class clazz2 : classesList) {
            try {
                listeners.add((TestExecutionListener)BeanUtils.instantiateClass((Class)clazz2));
            }
            catch (NoClassDefFoundError err) {
                if (defaultListeners) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Could not instantiate default TestExecutionListener class [" + clazz2.getName() + "]. Specify custom listener classes or make the default listener classes available."));
                    continue;
                }
                throw err;
            }
        }
        return listeners.toArray(new TestExecutionListener[listeners.size()]);
    }

    protected Set<Class<? extends TestExecutionListener>> getDefaultTestExecutionListenerClasses() {
        LinkedHashSet<Class<? extends TestExecutionListener>> defaultListenerClasses = new LinkedHashSet<Class<? extends TestExecutionListener>>();
        for (String className : DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES) {
            try {
                defaultListenerClasses.add(this.getClass().getClassLoader().loadClass(className));
            }
            catch (Throwable ex) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Could not load default TestExecutionListener class [" + className + "]. Specify custom listener classes or make the default listener classes available."));
            }
        }
        return defaultListenerClasses;
    }

    public void prepareTestInstance(Object testInstance) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("prepareTestInstance(): instance [" + testInstance + "]"));
        }
        this.getTestContext().updateState(testInstance, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.prepareTestInstance(this.getTestContext());
            }
            catch (Exception ex) {
                logger.error((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to prepare test instance [" + testInstance + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void beforeTestMethod(Object testInstance, Method testMethod) throws Exception {
        Assert.notNull((Object)testInstance, (String)"Test instance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeTestMethod(): instance [" + testInstance + "], method [" + testMethod + "]"));
        }
        this.getTestContext().updateState(testInstance, testMethod, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before' execution of test method [" + testMethod + "] for test instance [" + testInstance + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void afterTestMethod(Object testInstance, Method testMethod, Throwable exception) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterTestMethod(): instance [" + testInstance + "], method [" + testMethod + "], exception [" + exception + "]"));
        }
        this.getTestContext().updateState(testInstance, testMethod, exception);
        ArrayList<TestExecutionListener> listenersReversed = new ArrayList<TestExecutionListener>(this.getTestExecutionListeners());
        Collections.reverse(listenersReversed);
        Exception afterTestMethodException = null;
        for (TestExecutionListener testExecutionListener : listenersReversed) {
            try {
                testExecutionListener.afterTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after' execution for test: method [" + testMethod + "], instance [" + testInstance + "], exception [" + exception + "]"), (Throwable)ex);
                if (afterTestMethodException != null) continue;
                afterTestMethodException = ex;
            }
        }
        if (afterTestMethodException != null) {
            throw afterTestMethodException;
        }
    }
}

