/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpMethod;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.BearerTokenErrors;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.util.StringUtils;

public final class DefaultBearerTokenResolver
implements BearerTokenResolver {
    private static final String ACCESS_TOKEN_PARAMETER_NAME = "access_token";
    private static final Pattern authorizationPattern = Pattern.compile("^Bearer (?<token>[a-zA-Z0-9-._~+/]+=*)$", 2);
    private boolean allowFormEncodedBodyParameter = false;
    private boolean allowUriQueryParameter = false;
    private String bearerTokenHeaderName = "Authorization";

    @Override
    public String resolve(HttpServletRequest request) {
        return DefaultBearerTokenResolver.resolveToken(this.resolveFromAuthorizationHeader(request), this.resolveAccessTokenFromQueryString(request), this.resolveAccessTokenFromBody(request));
    }

    private static String resolveToken(String ... accessTokens) {
        if (accessTokens == null || accessTokens.length == 0) {
            return null;
        }
        String accessToken = null;
        for (String token : accessTokens) {
            if (accessToken == null) {
                accessToken = token;
                continue;
            }
            if (token == null) continue;
            BearerTokenError error = BearerTokenErrors.invalidRequest("Found multiple bearer tokens in the request");
            throw new OAuth2AuthenticationException((OAuth2Error)error);
        }
        if (accessToken != null && accessToken.isBlank()) {
            BearerTokenError error = BearerTokenErrors.invalidRequest("The requested token parameter is an empty string");
            throw new OAuth2AuthenticationException((OAuth2Error)error);
        }
        return accessToken;
    }

    private String resolveFromAuthorizationHeader(HttpServletRequest request) {
        String authorization = request.getHeader(this.bearerTokenHeaderName);
        if (!StringUtils.startsWithIgnoreCase((String)authorization, (String)"bearer")) {
            return null;
        }
        Matcher matcher = authorizationPattern.matcher(authorization);
        if (!matcher.matches()) {
            BearerTokenError error = BearerTokenErrors.invalidToken("Bearer token is malformed");
            throw new OAuth2AuthenticationException((OAuth2Error)error);
        }
        return matcher.group("token");
    }

    private String resolveAccessTokenFromQueryString(HttpServletRequest request) {
        if (!this.allowUriQueryParameter || !HttpMethod.GET.name().equals(request.getMethod())) {
            return null;
        }
        return DefaultBearerTokenResolver.resolveToken(request.getParameterValues(ACCESS_TOKEN_PARAMETER_NAME));
    }

    private String resolveAccessTokenFromBody(HttpServletRequest request) {
        if (!this.allowFormEncodedBodyParameter || !"application/x-www-form-urlencoded".equals(request.getContentType()) || HttpMethod.GET.name().equals(request.getMethod())) {
            return null;
        }
        String queryString = request.getQueryString();
        if (queryString != null && queryString.contains(ACCESS_TOKEN_PARAMETER_NAME)) {
            return null;
        }
        return DefaultBearerTokenResolver.resolveToken(request.getParameterValues(ACCESS_TOKEN_PARAMETER_NAME));
    }

    public void setAllowFormEncodedBodyParameter(boolean allowFormEncodedBodyParameter) {
        this.allowFormEncodedBodyParameter = allowFormEncodedBodyParameter;
    }

    public void setAllowUriQueryParameter(boolean allowUriQueryParameter) {
        this.allowUriQueryParameter = allowUriQueryParameter;
    }

    public void setBearerTokenHeaderName(String bearerTokenHeaderName) {
        this.bearerTokenHeaderName = bearerTokenHeaderName;
    }
}

