/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchConsumerAwareMessageListener;
import org.springframework.kafka.listener.ConsumerAwareMessageListener;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.ListenerType;
import org.springframework.util.Assert;

public final class ListenerUtils {
    private static final ThreadLocal<Boolean> LOG_METADATA_ONLY = new ThreadLocal();

    private ListenerUtils() {
    }

    public static ListenerType determineListenerType(Object listener) {
        ListenerType listenerType;
        Assert.notNull((Object)listener, (String)"Listener cannot be null");
        if (listener instanceof AcknowledgingConsumerAwareMessageListener || listener instanceof BatchAcknowledgingConsumerAwareMessageListener) {
            listenerType = ListenerType.ACKNOWLEDGING_CONSUMER_AWARE;
        } else if (listener instanceof ConsumerAwareMessageListener || listener instanceof BatchConsumerAwareMessageListener) {
            listenerType = ListenerType.CONSUMER_AWARE;
        } else if (listener instanceof AcknowledgingMessageListener || listener instanceof BatchAcknowledgingMessageListener) {
            listenerType = ListenerType.ACKNOWLEDGING;
        } else if (listener instanceof GenericMessageListener) {
            listenerType = ListenerType.SIMPLE;
        } else {
            throw new IllegalArgumentException("Unsupported listener type: " + listener.getClass().getName());
        }
        return listenerType;
    }

    public static void setLogOnlyMetadata(boolean onlyMeta) {
        LOG_METADATA_ONLY.set(onlyMeta);
    }

    public static String recordToString(ConsumerRecord<?, ?> record) {
        if (Boolean.TRUE.equals(LOG_METADATA_ONLY.get())) {
            return record.topic() + "-" + record.partition() + "@" + record.offset();
        }
        return record.toString();
    }
}

