/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.connection.zset.DefaultTuple;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class DefaultStringTuple
extends DefaultTuple
implements StringRedisConnection.StringTuple {
    private final String valueAsString;

    public DefaultStringTuple(byte[] value, String valueAsString, Double score) {
        super(value, score);
        this.valueAsString = valueAsString;
    }

    public DefaultStringTuple(String valueAsString, double score) {
        this(valueAsString.getBytes(StandardCharsets.UTF_8), valueAsString, score);
    }

    public DefaultStringTuple(Tuple tuple, String valueAsString) {
        super(tuple.getValue(), tuple.getScore());
        this.valueAsString = valueAsString;
    }

    @Override
    public String getValueAsString() {
        return this.valueAsString;
    }

    @Override
    public String toString() {
        return "DefaultStringTuple[value=" + this.getValueAsString() + ", score=" + this.getScore() + "]";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultStringTuple that = (DefaultStringTuple)o;
        return ObjectUtils.nullSafeEquals((Object)this.valueAsString, (Object)that.valueAsString);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.valueAsString);
        return result;
    }
}

