/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.reactive.RxQueryRunner;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.neo4j.core.DefaultReactiveNeo4jClient;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@API(status=API.Status.STABLE, since="6.0")
public interface ReactiveNeo4jClient {
    public static final LogAccessor cypherLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher"));

    public static ReactiveNeo4jClient create(Driver driver) {
        return new DefaultReactiveNeo4jClient(driver, ReactiveDatabaseSelectionProvider.getDefaultSelectionProvider());
    }

    public static ReactiveNeo4jClient create(Driver driver, ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
        return new DefaultReactiveNeo4jClient(driver, databaseSelectionProvider);
    }

    public RunnableSpec query(String var1);

    public RunnableSpec query(Supplier<String> var1);

    public <T> OngoingDelegation<T> delegateTo(Function<RxQueryRunner, Mono<T>> var1);

    public ReactiveDatabaseSelectionProvider getDatabaseSelectionProvider();

    public static interface RunnableDelegation<T> {
        public Mono<T> run();
    }

    public static interface OngoingDelegation<T>
    extends RunnableDelegation<T> {
        public RunnableDelegation<T> in(@Nullable String var1);
    }

    public static interface RunnableSpecTightToDatabase
    extends Neo4jClient.BindSpec<RunnableSpecTightToDatabase> {
        public <T> MappingSpec<T> fetchAs(Class<T> var1);

        public RecordFetchSpec<Map<String, Object>> fetch();

        public Mono<ResultSummary> run();
    }

    public static interface RunnableSpec
    extends RunnableSpecTightToDatabase {
        public RunnableSpecTightToDatabase in(@Nullable String var1);
    }

    public static interface RecordFetchSpec<T> {
        public Mono<T> one();

        public Mono<T> first();

        public Flux<T> all();
    }

    public static interface MappingSpec<T>
    extends RecordFetchSpec<T> {
        public RecordFetchSpec<T> mappedBy(BiFunction<TypeSystem, Record, T> var1);
    }
}

