/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.util.function.Function;
import org.neo4j.ogm.id.InternalIdStrategy;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultNeo4jIsNewStrategy
implements IsNewStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultNeo4jIsNewStrategy.class);
    private final boolean internallyGeneratedId;
    private final boolean externallyGeneratedId;
    private final boolean assignedId;
    private final Class<?> valueType;
    @Nullable
    private final Function<Object, Object> valueLookup;

    static IsNewStrategy basedOn(Neo4jPersistentEntity<?> entity, MetaData ogmMetadata) {
        Function<Object, Object> valueLookup;
        Class<Void> valueType;
        boolean assignedId;
        Assert.notNull(entity, (String)"Entity meta data must not be null.");
        ClassInfo classInfo = ogmMetadata.classInfo(entity.getType());
        boolean internallyGeneratedId = classInfo.hasIdentityField();
        boolean externallyGeneratedId = classInfo.idStrategyClass() != null && InternalIdStrategy.class != classInfo.idStrategyClass();
        boolean bl = assignedId = !internallyGeneratedId && classInfo.idStrategyClass() == null;
        if (classInfo.hasIdentityField()) {
            valueType = classInfo.identityField().type();
        } else if (classInfo.hasPrimaryIndexField()) {
            valueType = classInfo.primaryIndexField().type();
        } else {
            throw new IllegalStateException(String.format("Required identifier property not found for %s!", entity.getType()));
        }
        if (externallyGeneratedId && valueType.isPrimitive()) {
            throw new IllegalArgumentException(String.format("Cannot use %s with externally generated, primitive ids.", DefaultNeo4jIsNewStrategy.class.getName()));
        }
        Neo4jPersistentProperty versionProperty = (Neo4jPersistentProperty)entity.getVersionProperty();
        if (assignedId) {
            if (versionProperty == null) {
                log.warn("Instances of " + entity.getType() + " with an assigned id will always be treated as new without version property!");
                valueType = Void.class;
                valueLookup = source -> null;
            } else {
                valueType = versionProperty.getType();
                valueLookup = source -> entity.getPropertyAccessor(source).getProperty((PersistentProperty)versionProperty);
            }
        } else {
            valueLookup = source -> entity.getIdentifierAccessor(source).getIdentifier();
        }
        return new DefaultNeo4jIsNewStrategy(internallyGeneratedId, externallyGeneratedId, assignedId, valueType, valueLookup);
    }

    private DefaultNeo4jIsNewStrategy(boolean internallyGeneratedId, boolean externallyGeneratedId, boolean assignedId, Class<?> valueType, @Nullable Function<Object, Object> valueLookup) {
        this.internallyGeneratedId = internallyGeneratedId;
        this.externallyGeneratedId = externallyGeneratedId;
        this.assignedId = assignedId;
        this.valueType = valueType;
        this.valueLookup = valueLookup;
    }

    public boolean isNew(Object entity) {
        Object value = this.valueLookup.apply(entity);
        if (this.internallyGeneratedId) {
            return value == null || value instanceof Long && (Long)value < 0L;
        }
        if (this.externallyGeneratedId) {
            return value == null;
        }
        if (this.assignedId) {
            if (this.valueType != null && !this.valueType.isPrimitive()) {
                return value == null;
            }
            if (Number.class.isInstance(value)) {
                return ((Number)value).longValue() == 0L;
            }
        }
        throw new IllegalArgumentException(String.format("Could not determine whether %s is new! Unsupported identifier or version property!", entity));
    }
}

