/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.mysema.query.jpa.EclipseLinkTemplates;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.OpenJPATemplates;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.path.PathBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.PersistenceProvider;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.QSort;
import org.springframework.util.Assert;

public class Querydsl {
    private final EntityManager em;
    private final PersistenceProvider provider;
    private final PathBuilder<?> builder;

    public Querydsl(EntityManager em, PathBuilder<?> builder) {
        Assert.notNull((Object)em);
        Assert.notNull(builder);
        this.em = em;
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.builder = builder;
    }

    public JPQLQuery createQuery() {
        switch (this.provider) {
            case ECLIPSELINK: {
                return new JPAQuery(this.em, (JPQLTemplates)EclipseLinkTemplates.DEFAULT);
            }
            case HIBERNATE: {
                return new JPAQuery(this.em, (JPQLTemplates)HQLTemplates.DEFAULT);
            }
            case OPEN_JPA: {
                return new JPAQuery(this.em, (JPQLTemplates)OpenJPATemplates.DEFAULT);
            }
        }
        return new JPAQuery(this.em);
    }

    public JPQLQuery createQuery(EntityPath<?> ... paths) {
        return (JPQLQuery)this.createQuery().from(paths);
    }

    public JPQLQuery applyPagination(Pageable pageable, JPQLQuery query) {
        if (pageable == null) {
            return query;
        }
        query.offset((long)pageable.getOffset());
        query.limit((long)pageable.getPageSize());
        return this.applySorting(pageable.getSort(), query);
    }

    public JPQLQuery applySorting(Sort sort, JPQLQuery query) {
        if (sort == null) {
            return query;
        }
        if (sort instanceof QSort) {
            return this.addOrderByFrom((QSort)sort, query);
        }
        return this.addOrderByFrom(sort, query);
    }

    private JPQLQuery addOrderByFrom(QSort qsort, JPQLQuery query) {
        return (JPQLQuery)query.orderBy(this.adjustOrderSpecifierIfNecessary(qsort.getOrderSpecifiers(), query));
    }

    private OrderSpecifier<?>[] adjustOrderSpecifierIfNecessary(List<OrderSpecifier<?>> originalOrderSpecifiers, JPQLQuery query) {
        Assert.notNull(originalOrderSpecifiers, (String)"Original order specifiers must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be null!");
        boolean orderModificationNecessary = false;
        ArrayList<Object> modifiedOrderSpecifiers = new ArrayList<Object>();
        for (OrderSpecifier<?> order : originalOrderSpecifiers) {
            Path targetPath = ((Path)order.getTarget()).getMetadata().getParent();
            boolean targetPathRootIsEntityRoot = targetPath.getRoot().equals(this.builder.getRoot());
            boolean targetPathEqualsRootEnityPath = targetPath.toString().equals(this.builder.toString());
            if (!targetPathRootIsEntityRoot) {
                query.leftJoin((EntityPath)this.builder.get((String)targetPath.getMetadata().getElement()), targetPath);
            } else if (targetPathRootIsEntityRoot && !targetPathEqualsRootEnityPath) {
                PathBuilder joinPathBuilder = new PathBuilder(targetPath.getType(), targetPath.getMetadata().getElement().toString());
                query.leftJoin((EntityPath)targetPath, (Path)joinPathBuilder);
                OrderSpecifier modifiedOrder = new OrderSpecifier(order.getOrder(), (Expression)joinPathBuilder.get(((Path)order.getTarget()).getMetadata().getElement().toString()), order.getNullHandling());
                modifiedOrderSpecifiers.add(modifiedOrder);
                orderModificationNecessary = true;
                continue;
            }
            modifiedOrderSpecifiers.add(order);
        }
        return orderModificationNecessary ? modifiedOrderSpecifiers.toArray(new OrderSpecifier[modifiedOrderSpecifiers.size()]) : originalOrderSpecifiers.toArray(new OrderSpecifier[originalOrderSpecifiers.size()]);
    }

    private JPQLQuery addOrderByFrom(Sort sort, JPQLQuery query) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be null!");
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrderSpecifier(order, query)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrderSpecifier(Sort.Order order, JPQLQuery query) {
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, this.buildOrderPropertyPathFrom(order), OrderSpecifier.NullHandling.NullsLast);
    }

    private Expression<?> buildOrderPropertyPathFrom(Sort.Order order) {
        Assert.notNull((Object)order, (String)"Order must not be null!");
        Object sortPropertyExpression = this.builder;
        for (PropertyPath path = PropertyPath.from((String)order.getProperty(), (Class)this.builder.getType()); path != null; path = path.next()) {
            sortPropertyExpression = !path.hasNext() && order.isIgnoreCase() ? sortPropertyExpression.getString(path.getSegment()).lower() : sortPropertyExpression.get(path.getSegment());
        }
        return sortPropertyExpression;
    }
}

