/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support.querybyexample;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.CriteriaQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.support.querybyexample.ExampleCriteriaMapper;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.repository.query.ReactiveQueryByExampleExecutor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveQueryByExampleElasticsearchExecutor<T>
implements ReactiveQueryByExampleExecutor<T> {
    protected ReactiveElasticsearchOperations operations;
    protected ExampleCriteriaMapper exampleCriteriaMapper;

    public ReactiveQueryByExampleElasticsearchExecutor(ReactiveElasticsearchOperations operations) {
        this.operations = operations;
        this.exampleCriteriaMapper = new ExampleCriteriaMapper(operations.getElasticsearchConverter().getMappingContext());
    }

    public <S extends T> Mono<S> findOne(Example<S> example) {
        return Mono.just(example).map(e -> ((CriteriaQueryBuilder)CriteriaQuery.builder(this.exampleCriteriaMapper.criteria(e)).withMaxResults(2)).build()).flatMapMany(criteriaQuery -> this.operations.search((Query)criteriaQuery, example.getProbeType(), this.operations.getIndexCoordinatesFor(example.getProbeType()))).buffer(2).map(searchHitList -> {
            if (searchHitList.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            return (SearchHit)searchHitList.iterator().next();
        }).map(SearchHit::getContent).next();
    }

    public <S extends T> Flux<S> findAll(Example<S> example) {
        return Mono.just(example).map(e -> new CriteriaQuery(this.exampleCriteriaMapper.criteria(e))).flatMapMany(criteriaQuery -> this.operations.search((Query)criteriaQuery, example.getProbeType(), this.operations.getIndexCoordinatesFor(example.getProbeType()))).map(SearchHit::getContent);
    }

    public <S extends T> Flux<S> findAll(Example<S> example, Sort sort) {
        return Mono.just(example).map(e -> ((CriteriaQueryBuilder)CriteriaQuery.builder(this.exampleCriteriaMapper.criteria(e)).withSort(sort)).build()).flatMapMany(criteriaQuery -> this.operations.search((Query)criteriaQuery, example.getProbeType(), this.operations.getIndexCoordinatesFor(example.getProbeType()))).map(SearchHit::getContent);
    }

    public <S extends T> Mono<Long> count(Example<S> example) {
        return Mono.just(example).map(e -> new CriteriaQuery(this.exampleCriteriaMapper.criteria(e))).flatMap(criteriaQuery -> this.operations.count((Query)criteriaQuery, example.getProbeType(), this.operations.getIndexCoordinatesFor(example.getProbeType())));
    }

    public <S extends T> Mono<Boolean> exists(Example<S> example) {
        return this.count(example).map(count -> count > 0L);
    }

    public <S extends T, R, P extends Publisher<R>> P findBy(Example<S> example, Function<FluentQuery.ReactiveFluentQuery<S>, P> queryFunction) {
        throw new UnsupportedOperationException("findBy example and queryFunction is not supported");
    }
}

