/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsImpl;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.SearchShardStatistics;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.suggest.response.CompletionSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SearchHitMapping<T> {
    private final Class<T> type;
    private final ElasticsearchConverter converter;
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    private SearchHitMapping(Class<T> type, ElasticsearchConverter converter) {
        Assert.notNull(type, (String)"type is null");
        Assert.notNull((Object)converter, (String)"converter is null");
        this.type = type;
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    public static <T> SearchHitMapping<T> mappingFor(Class<T> entityClass, ElasticsearchConverter converter) {
        return new SearchHitMapping<T>(entityClass, converter);
    }

    public SearchHits<T> mapHits(SearchDocumentResponse searchDocumentResponse, List<T> contents) {
        return this.mapHitsFromResponse(searchDocumentResponse, contents);
    }

    SearchScrollHits<T> mapScrollHits(SearchDocumentResponse searchDocumentResponse, List<T> contents) {
        return this.mapHitsFromResponse(searchDocumentResponse, contents);
    }

    private SearchHitsImpl<T> mapHitsFromResponse(SearchDocumentResponse searchDocumentResponse, List<T> contents) {
        Assert.notNull((Object)searchDocumentResponse, (String)"searchDocumentResponse is null");
        Assert.notNull(contents, (String)"contents is null");
        Assert.isTrue((searchDocumentResponse.getSearchDocuments().size() == contents.size() ? 1 : 0) != 0, (String)"Count of documents must match the count of entities");
        long totalHits = searchDocumentResponse.getTotalHits();
        SearchShardStatistics shardStatistics = searchDocumentResponse.getSearchShardStatistics();
        float maxScore = searchDocumentResponse.getMaxScore();
        Duration executionDuration = searchDocumentResponse.getExecutionDuration();
        String scrollId = searchDocumentResponse.getScrollId();
        String pointInTimeId = searchDocumentResponse.getPointInTimeId();
        ArrayList<SearchHit<T>> searchHits = new ArrayList<SearchHit<T>>();
        List<SearchDocument> searchDocuments = searchDocumentResponse.getSearchDocuments();
        for (int i = 0; i < searchDocuments.size(); ++i) {
            SearchDocument document = searchDocuments.get(i);
            T content = contents.get(i);
            SearchHit<T> hit = this.mapHit(document, content);
            searchHits.add(hit);
        }
        AggregationsContainer<?> aggregations = searchDocumentResponse.getAggregations();
        TotalHitsRelation totalHitsRelation = TotalHitsRelation.valueOf(searchDocumentResponse.getTotalHitsRelation());
        Suggest suggest = searchDocumentResponse.getSuggest();
        this.mapHitsInCompletionSuggestion(suggest);
        return new SearchHitsImpl(totalHits, totalHitsRelation, maxScore, executionDuration, scrollId, pointInTimeId, searchHits, aggregations, suggest, shardStatistics);
    }

    public void mapHitsInCompletionSuggestion(@Nullable Suggest suggest) {
        if (suggest != null) {
            for (Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion : suggest.getSuggestions()) {
                if (!(suggestion instanceof CompletionSuggestion)) continue;
                CompletionSuggestion completionSuggestion = (CompletionSuggestion)suggestion;
                for (CompletionSuggestion.Entry entry : completionSuggestion.getEntries()) {
                    for (CompletionSuggestion.Entry.Option option : entry.getOptions()) {
                        option.updateSearchHit(this::mapHit);
                    }
                }
            }
        }
    }

    public SearchHit<T> mapHit(SearchDocument searchDocument, T content) {
        Assert.notNull((Object)searchDocument, (String)"searchDocument is null");
        Assert.notNull(content, (String)"content is null");
        return new SearchHit<T>(searchDocument.getIndex(), searchDocument.hasId() ? searchDocument.getId() : null, searchDocument.getRouting(), searchDocument.getScore(), searchDocument.getSortValues(), this.getHighlightsAndRemapFieldNames(searchDocument), this.mapInnerHits(searchDocument), searchDocument.getNestedMetaData(), searchDocument.getExplanation(), searchDocument.getMatchedQueries(), content);
    }

    @Nullable
    private Map<String, List<String>> getHighlightsAndRemapFieldNames(SearchDocument searchDocument) {
        Map<String, List<String>> highlightFields = searchDocument.getHighlightFields();
        if (highlightFields == null) {
            return null;
        }
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(this.type);
        if (persistentEntity == null) {
            return highlightFields;
        }
        return highlightFields.entrySet().stream().collect(Collectors.toMap(entry -> {
            ElasticsearchPersistentProperty property = persistentEntity.getPersistentPropertyWithFieldName((String)entry.getKey());
            return property != null ? property.getName() : (String)entry.getKey();
        }, Map.Entry::getValue));
    }

    private Map<String, SearchHits<?>> mapInnerHits(SearchDocument searchDocument) {
        LinkedHashMap innerHits = new LinkedHashMap();
        Map<String, SearchDocumentResponse> documentInnerHits = searchDocument.getInnerHits();
        if (documentInnerHits != null && !documentInnerHits.isEmpty()) {
            SearchHitMapping<SearchDocument> searchDocumentSearchHitMapping = SearchHitMapping.mappingFor(SearchDocument.class, this.converter);
            for (Map.Entry<String, SearchDocumentResponse> entry : documentInnerHits.entrySet()) {
                SearchDocumentResponse searchDocumentResponse = entry.getValue();
                SearchHitsImpl<SearchDocument> searchHits = searchDocumentSearchHitMapping.mapHitsFromResponse(searchDocumentResponse, searchDocumentResponse.getSearchDocuments());
                SearchHits<?> mappedSearchHits = this.mapInnerDocuments(searchHits, this.type);
                innerHits.put(entry.getKey(), mappedSearchHits);
            }
        }
        return innerHits;
    }

    private SearchHits<?> mapInnerDocuments(SearchHits<SearchDocument> searchHits, Class<T> type) {
        if (searchHits.isEmpty()) {
            return searchHits;
        }
        try {
            ElasticsearchPersistentEntity persistentEntityForType = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(type);
            NestedMetaData nestedMetaData = searchHits.getSearchHit(0).getContent().getNestedMetaData();
            ElasticsearchPersistentEntityWithNestedMetaData persistentEntityWithNestedMetaData = this.getPersistentEntity(persistentEntityForType, nestedMetaData);
            if (persistentEntityWithNestedMetaData.entity != null) {
                ArrayList convertedSearchHits = new ArrayList();
                Class targetType = persistentEntityWithNestedMetaData.entity.getType();
                searchHits.getSearchHits().forEach(searchHit -> {
                    SearchDocument searchDocument = (SearchDocument)searchHit.getContent();
                    Object targetObject = this.converter.read(targetType, searchDocument);
                    convertedSearchHits.add(new SearchHit<Object>(searchDocument.getIndex(), searchDocument.getId(), searchDocument.getRouting(), searchDocument.getScore(), searchDocument.getSortValues(), searchDocument.getHighlightFields(), searchHit.getInnerHits(), this.getPersistentEntity(persistentEntityForType, (NestedMetaData)((SearchDocument)searchHit.getContent()).getNestedMetaData()).nestedMetaData, searchHit.getExplanation(), searchHit.getMatchedQueries(), targetObject));
                });
                String scrollId = null;
                if (searchHits instanceof SearchHitsImpl) {
                    SearchHitsImpl searchHitsImpl = (SearchHitsImpl)searchHits;
                    scrollId = searchHitsImpl.getScrollId();
                }
                return new SearchHitsImpl(searchHits.getTotalHits(), searchHits.getTotalHitsRelation(), searchHits.getMaxScore(), searchHits.getExecutionDuration(), scrollId, searchHits.getPointInTimeId(), convertedSearchHits, searchHits.getAggregations(), searchHits.getSuggest(), searchHits.getSearchShardStatistics());
            }
        }
        catch (Exception e) {
            throw new UncategorizedElasticsearchException("Unable to convert inner hits.", e);
        }
        return searchHits;
    }

    private ElasticsearchPersistentEntityWithNestedMetaData getPersistentEntity(@Nullable ElasticsearchPersistentEntity<?> persistentEntity, @Nullable NestedMetaData nestedMetaData) {
        NestedMetaData currentMetaData = nestedMetaData;
        LinkedList<NestedMetaData> mappedNestedMetaDatas = new LinkedList<NestedMetaData>();
        while (persistentEntity != null && currentMetaData != null) {
            ElasticsearchPersistentProperty persistentProperty = persistentEntity.getPersistentPropertyWithFieldName(currentMetaData.getField());
            if (persistentProperty == null) {
                persistentEntity = null;
                continue;
            }
            persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(persistentProperty.getActualType());
            mappedNestedMetaDatas.add(0, NestedMetaData.of(persistentProperty.getName(), currentMetaData.getOffset(), null));
            currentMetaData = currentMetaData.getChild();
        }
        NestedMetaData mappedNestedMetaData = mappedNestedMetaDatas.stream().reduce(null, (result, nmd) -> NestedMetaData.of(nmd.getField(), nmd.getOffset(), result));
        return new ElasticsearchPersistentEntityWithNestedMetaData(persistentEntity, mappedNestedMetaData);
    }

    private static class ElasticsearchPersistentEntityWithNestedMetaData {
        @Nullable
        private final ElasticsearchPersistentEntity<?> entity;
        private final NestedMetaData nestedMetaData;

        public ElasticsearchPersistentEntityWithNestedMetaData(@Nullable ElasticsearchPersistentEntity<?> entity, NestedMetaData nestedMetaData) {
            this.entity = entity;
            this.nestedMetaData = nestedMetaData;
        }
    }
}

