/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;
import org.springframework.data.elasticsearch.annotations.GeoShapeField;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.annotations.Parent;
import org.springframework.data.elasticsearch.annotations.Score;
import org.springframework.data.elasticsearch.core.completion.Completion;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchDateConverter;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.join.JoinField;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentPropertyConverter;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class SimpleElasticsearchPersistentProperty
extends AnnotationBasedPersistentProperty<ElasticsearchPersistentProperty>
implements ElasticsearchPersistentProperty {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleElasticsearchPersistentProperty.class);
    private static final List<String> SUPPORTED_ID_PROPERTY_NAMES = Arrays.asList("id", "document");
    private final boolean isScore;
    private final boolean isParent;
    private final boolean isId;
    private final boolean isSeqNoPrimaryTerm;
    @Nullable
    private final String annotatedFieldName = this.getAnnotatedFieldName();
    @Nullable
    private ElasticsearchPersistentPropertyConverter propertyConverter;
    private final boolean storeNullValue;

    public SimpleElasticsearchPersistentProperty(Property property, PersistentEntity<?, ElasticsearchPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        boolean isIdWithoutAnnotation;
        this.isId = super.isIdProperty() || SUPPORTED_ID_PROPERTY_NAMES.contains(this.getFieldName());
        boolean bl = isIdWithoutAnnotation = this.isId && !this.isAnnotationPresent(Id.class);
        if (isIdWithoutAnnotation) {
            LOGGER.warn("Using the property name of '{}' to identify the id property is deprecated. Please annotate the id property with '@Id'", (Object)this.getName());
        }
        this.isScore = this.isAnnotationPresent(Score.class);
        this.isParent = this.isAnnotationPresent(Parent.class);
        this.isSeqNoPrimaryTerm = SeqNoPrimaryTerm.class.isAssignableFrom(this.getRawType());
        boolean isField = this.isAnnotationPresent(Field.class);
        if (this.isVersionProperty() && !this.getType().equals(Long.class)) {
            throw new MappingException(String.format("Version property %s must be of type Long!", property.getName()));
        }
        if (this.isScore && !this.getType().equals(Float.TYPE) && !this.getType().equals(Float.class)) {
            throw new MappingException(String.format("Score property %s must be either of type float or Float!", property.getName()));
        }
        if (this.isParent && !this.getType().equals(String.class)) {
            throw new MappingException(String.format("Parent property %s must be of type String!", property.getName()));
        }
        if (isField && this.isAnnotationPresent(MultiField.class)) {
            throw new MappingException("@Field annotation must not be used on a @MultiField property.");
        }
        this.initDateConverter();
        this.storeNullValue = isField && ((Field)this.getRequiredAnnotation(Field.class)).storeNullValue();
    }

    @Override
    public boolean hasPropertyConverter() {
        return this.propertyConverter != null;
    }

    @Override
    @Nullable
    public ElasticsearchPersistentPropertyConverter getPropertyConverter() {
        return this.propertyConverter;
    }

    public boolean isWritable() {
        return super.isWritable() && !this.isSeqNoPrimaryTermProperty();
    }

    @Override
    public boolean isReadable() {
        return !this.isTransient() && !this.isSeqNoPrimaryTermProperty();
    }

    @Override
    public boolean storeNullValue() {
        return this.storeNullValue;
    }

    private void initDateConverter() {
        Field field = (Field)this.findAnnotation(Field.class);
        final Class actualType = this.getActualTypeOrNull();
        if (actualType == null) {
            return;
        }
        final boolean isTemporalAccessor = TemporalAccessor.class.isAssignableFrom(actualType);
        final boolean isDate = Date.class.isAssignableFrom(actualType);
        if (field != null && (field.type() == FieldType.Date || field.type() == FieldType.Date_Nanos) && (isTemporalAccessor || isDate)) {
            ElasticsearchDateConverter converter;
            DateFormat dateFormat = field.format();
            if (dateFormat == DateFormat.none) {
                throw new MappingException(String.format("Property %s is annotated with FieldType.%s but has no DateFormat defined", this.getOwner().getType().getSimpleName() + "." + this.getName(), field.type().name()));
            }
            if (dateFormat == DateFormat.custom) {
                String pattern = field.pattern();
                if (!StringUtils.hasLength((String)pattern)) {
                    throw new MappingException(String.format("Property %s is annotated with FieldType.%s and a custom format but has no pattern defined", this.getOwner().getType().getSimpleName() + "." + this.getName(), field.type().name()));
                }
                converter = ElasticsearchDateConverter.of(pattern);
            } else {
                converter = ElasticsearchDateConverter.of(dateFormat);
            }
            this.propertyConverter = new ElasticsearchPersistentPropertyConverter(){
                final ElasticsearchDateConverter dateConverter;
                {
                    this.dateConverter = converter;
                }

                @Override
                public String write(Object property) {
                    if (isTemporalAccessor && TemporalAccessor.class.isAssignableFrom(property.getClass())) {
                        return this.dateConverter.format((TemporalAccessor)property);
                    }
                    if (isDate && Date.class.isAssignableFrom(property.getClass())) {
                        return this.dateConverter.format((Date)property);
                    }
                    return property.toString();
                }

                @Override
                public Object read(String s) {
                    if (isTemporalAccessor) {
                        return this.dateConverter.parse(s, actualType);
                    }
                    return this.dateConverter.parse(s);
                }
            };
        }
    }

    @Nullable
    private String getAnnotatedFieldName() {
        String name = null;
        if (this.isAnnotationPresent(Field.class)) {
            name = ((Field)this.findAnnotation(Field.class)).name();
        } else if (this.isAnnotationPresent(MultiField.class)) {
            name = ((MultiField)this.findAnnotation(MultiField.class)).mainField().name();
        }
        return StringUtils.hasText((String)name) ? name : null;
    }

    @Override
    public String getFieldName() {
        return this.annotatedFieldName == null ? this.getProperty().getName() : this.annotatedFieldName;
    }

    public boolean isIdProperty() {
        return this.isId;
    }

    protected Association<ElasticsearchPersistentProperty> createAssociation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isScoreProperty() {
        return this.isScore;
    }

    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isParentProperty() {
        return this.isParent;
    }

    @Override
    public boolean isSeqNoPrimaryTermProperty() {
        return this.isSeqNoPrimaryTerm;
    }

    @Override
    public boolean isGeoPointProperty() {
        return this.getActualType() == GeoPoint.class || this.isAnnotationPresent(GeoPointField.class);
    }

    @Override
    public boolean isGeoShapeProperty() {
        return GeoJson.class.isAssignableFrom(this.getActualType()) || this.isAnnotationPresent(GeoShapeField.class);
    }

    @Override
    public boolean isJoinFieldProperty() {
        return this.getActualType() == JoinField.class;
    }

    @Override
    public boolean isCompletionProperty() {
        return this.getActualType() == Completion.class;
    }
}

