/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import org.springframework.data.convert.EntityConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface ElasticsearchConverter
extends EntityConverter<ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty, Object, Document> {
    default public ProjectionFactory getProjectionFactory() {
        return new SpelAwareProxyProjectionFactory();
    }

    default public String convertId(Object idValue) {
        Assert.notNull((Object)idValue, (String)"idValue must not be null!");
        if (!this.getConversionService().canConvert(idValue.getClass(), String.class)) {
            return idValue.toString();
        }
        return (String)this.getConversionService().convert(idValue, String.class);
    }

    default public Document mapObject(@Nullable Object source) {
        Document target = Document.create();
        if (source != null) {
            this.write(source, target);
        }
        return target;
    }

    default public void updateQuery(Query query, @Nullable Class<?> domainClass) {
        if (domainClass != null && query instanceof CriteriaQuery) {
            this.updateCriteriaQuery((CriteriaQuery)query, domainClass);
        }
    }

    public void updateCriteriaQuery(CriteriaQuery var1, Class<?> var2);
}

