/*
 * Copyright 2013-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.elasticsearch;

import java.util.Map;

import org.springframework.lang.Nullable;

/**
 * ElasticsearchException
 *
 * @author Rizwan Idrees
 * @author Mohsin Husen
 * @author Peter-Josef Meisch
 * @deprecated since 4.0, use {@link org.springframework.dao.UncategorizedDataAccessException}
 */
@Deprecated
public class ElasticsearchException extends RuntimeException {

	@Nullable private Map<String, String> failedDocuments;

	public ElasticsearchException(String message) {
		super(message);
	}

	public ElasticsearchException(String message, Throwable cause) {
		super(message, cause);
	}

	public ElasticsearchException(String message, Throwable cause, Map<String, String> failedDocuments) {
		super(message, cause);
		this.failedDocuments = failedDocuments;
	}

	public ElasticsearchException(String message, Map<String, String> failedDocuments) {
		super(message);
		this.failedDocuments = failedDocuments;
	}

	@Nullable
	public Map<String, String> getFailedDocuments() {
		return failedDocuments;
	}
}
