/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.ObjectUtils;

class PartitionAwareFunctionWrapper
implements Function<Object, Object>,
Supplier<Object> {
    protected final Log logger = LogFactory.getLog(PartitionAwareFunctionWrapper.class);
    protected final Function function;
    private final Function<Object, Object> outputMessageEnricher;
    private boolean messageEnricherEnabled = true;

    PartitionAwareFunctionWrapper(Function<?, ?> function, ConfigurableApplicationContext context, ProducerProperties producerProperties) {
        this.function = function;
        if (producerProperties != null && producerProperties.isPartitioned()) {
            StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)context.getBeanFactory());
            PartitionHandler partitionHandler = new PartitionHandler((EvaluationContext)evaluationContext, producerProperties, context.getBeanFactory());
            this.outputMessageEnricher = output -> {
                if (ObjectUtils.isArray((Object)output) && !(output instanceof byte[]) || output instanceof Iterable) {
                    return output;
                }
                if (!(output instanceof Message)) {
                    output = MessageBuilder.withPayload((Object)output).build();
                }
                return this.toMessageWithPartitionHeader((Message)output, partitionHandler);
            };
        } else {
            this.outputMessageEnricher = null;
        }
    }

    private Message<?> toMessageWithPartitionHeader(Message message, PartitionHandler partitionHandler) {
        int partitionId = partitionHandler.determinePartition(message);
        return MessageBuilder.fromMessage((Message)message).setHeader("scst_partition", (Object)partitionId).build();
    }

    @Override
    public Object apply(Object input) {
        if (this.messageEnricherEnabled) {
            this.setEnhancerIfNecessary();
        }
        Object result = this.function.apply(input);
        if (!((SimpleFunctionRegistry.FunctionInvocationWrapper)this.function).isInputTypePublisher()) {
            ((SimpleFunctionRegistry.FunctionInvocationWrapper)this.function).setEnhancer(null);
        }
        return result;
    }

    @Override
    public Object get() {
        Function function = this.function;
        if (function instanceof SimpleFunctionRegistry.FunctionInvocationWrapper) {
            SimpleFunctionRegistry.FunctionInvocationWrapper functionInvocationWrapper = (SimpleFunctionRegistry.FunctionInvocationWrapper)function;
            if (this.messageEnricherEnabled) {
                this.setEnhancerIfNecessary();
            }
            return functionInvocationWrapper.get();
        }
        throw new IllegalStateException("Call to get() is not allowed since this function is not a Supplier.");
    }

    private void setEnhancerIfNecessary() {
        Function function = this.function;
        if (function instanceof SimpleFunctionRegistry.FunctionInvocationWrapper) {
            SimpleFunctionRegistry.FunctionInvocationWrapper functionInvocationWrapper = (SimpleFunctionRegistry.FunctionInvocationWrapper)function;
            functionInvocationWrapper.setEnhancer(this.outputMessageEnricher);
        }
    }

    public void setMessageEnricherEnabled(boolean messageEnricherEnabled) {
        this.messageEnricherEnabled = messageEnricherEnabled;
    }
}

