/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.sidecar;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.discovery.EurekaClientConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.sidecar.LocalApplicationHealthCheckHandler;
import org.springframework.cloud.netflix.sidecar.LocalApplicationHealthIndicator;
import org.springframework.cloud.netflix.sidecar.SidecarController;
import org.springframework.cloud.netflix.sidecar.SidecarProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties
@ConditionalOnProperty(value={"spring.cloud.netflix.sidecar.enabled"}, matchIfMissing=true)
public class SidecarConfiguration {
    @Bean
    public HasFeatures Feature() {
        return HasFeatures.namedFeature((String)"Netflix Sidecar", SidecarConfiguration.class);
    }

    @Bean
    public SidecarProperties sidecarProperties() {
        return new SidecarProperties();
    }

    @Bean
    public LocalApplicationHealthIndicator localApplicationHealthIndicator() {
        return new LocalApplicationHealthIndicator();
    }

    @Bean
    public SidecarController sidecarController() {
        return new SidecarController();
    }

    @Configuration
    @ConditionalOnClass(value={EurekaClientConfig.class})
    protected static class EurekaInstanceConfigBeanConfiguration {
        @Autowired
        private SidecarProperties sidecarProperties;
        @Autowired
        private InetUtils inetUtils;
        @Value(value="${management.port:${MANAGEMENT_PORT:${server.port:${SERVER_PORT:${PORT:8080}}}}}")
        private int managementPort = 8080;
        @Value(value="${eureka.instance.hostname:${EUREKA_INSTANCE_HOSTNAME:}}")
        private String hostname;
        @Autowired
        private ConfigurableEnvironment env;

        protected EurekaInstanceConfigBeanConfiguration() {
        }

        @Bean
        public EurekaInstanceConfigBean eurekaInstanceConfigBean() {
            EurekaInstanceConfigBean config = new EurekaInstanceConfigBean(this.inetUtils);
            RelaxedPropertyResolver springPropertyResolver = new RelaxedPropertyResolver((PropertyResolver)this.env, "spring.application.");
            String springAppName = springPropertyResolver.getProperty("name");
            int port = this.sidecarProperties.getPort();
            config.setNonSecurePort(port);
            config.setInstanceId(IdUtils.getDefaultInstanceId((PropertyResolver)this.env));
            if (StringUtils.hasText((String)springAppName)) {
                config.setAppname(springAppName);
                config.setVirtualHostName(springAppName);
                config.setSecureVirtualHostName(springAppName);
            }
            if (StringUtils.hasText((String)this.hostname)) {
                config.setHostname(this.hostname);
            }
            String scheme = config.getSecurePortEnabled() ? "https" : "http";
            config.setStatusPageUrl(scheme + "://" + config.getHostname() + ":" + this.managementPort + config.getStatusPageUrlPath());
            config.setHealthCheckUrl(scheme + "://" + config.getHostname() + ":" + this.managementPort + config.getHealthCheckUrlPath());
            config.setHomePageUrl(scheme + "://" + config.getHostname() + ":" + port + config.getHomePageUrlPath());
            return config;
        }

        @Bean
        public HealthCheckHandler healthCheckHandler(LocalApplicationHealthIndicator healthIndicator) {
            return new LocalApplicationHealthCheckHandler((HealthIndicator)healthIndicator);
        }
    }
}

