/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.config;

import java.util.Arrays;
import java.util.Set;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.cloud.gateway.server.mvc.config.FilterProperties;
import org.springframework.cloud.gateway.server.mvc.config.PredicateProperties;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.cloud.gateway.server.mvc.filter.AfterFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.BeforeFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.BodyFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.Bucket4jFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.CircuitBreakerFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.FilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.LoadBalancerFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.LoadBalancerHandlerSupplier;
import org.springframework.cloud.gateway.server.mvc.filter.TokenRelayFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayRouterFunctions;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerFunctions;
import org.springframework.cloud.gateway.server.mvc.predicate.GatewayRequestPredicates;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;

public class GatewayMvcAotRuntimeHintsRegistrar
implements RuntimeHintsRegistrar {
    private static final Set<Class<?>> FUNCTION_PROVIDERS = Set.of(HandlerFunctions.class, LoadBalancerHandlerSupplier.class, FilterFunctions.class, BeforeFilterFunctions.class, AfterFilterFunctions.class, TokenRelayFilterFunctions.class, BodyFilterFunctions.class, CircuitBreakerFilterFunctions.class, GatewayRouterFunctions.class, LoadBalancerFilterFunctions.class, GatewayRequestPredicates.class, Bucket4jFilterFunctions.class);
    private static final Set<Class<?>> PROPERTIES = Set.of(FilterProperties.class, PredicateProperties.class, RouteProperties.class);

    public void registerHints(@NonNull RuntimeHints hints, ClassLoader classLoader) {
        ReflectionHints reflectionHints = hints.reflection();
        FUNCTION_PROVIDERS.forEach(clazz -> this.addHintsForClass(reflectionHints, (Class<?>)clazz, classLoader));
        PROPERTIES.forEach(clazz -> reflectionHints.registerType(clazz, new MemberCategory[]{MemberCategory.PUBLIC_FIELDS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS}));
    }

    private void addHintsForClass(ReflectionHints reflectionHints, Class<?> clazz, ClassLoader classLoader) {
        if (!ClassUtils.isPresent((String)clazz.getName(), (ClassLoader)classLoader)) {
            return;
        }
        Arrays.stream(clazz.getMethods()).forEach(method -> reflectionHints.registerMethod(method, ExecutableMode.INVOKE));
    }
}

