/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Map;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class QueueParser
extends AbstractSingleBeanDefinitionParser {
    private static final ThreadLocal<Element> CURRENT_ELEMENT = new ThreadLocal();
    private static final String ARGUMENTS = "queue-arguments";
    private static final String DURABLE_ATTRIBUTE = "durable";
    private static final String EXCLUSIVE_ATTRIBUTE = "exclusive";
    private static final String AUTO_DELETE_ATTRIBUTE = "auto-delete";
    private static final String REF_ATTRIBUTE = "ref";
    private static final String NAMING_STRATEGY = "naming-strategy";

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected boolean shouldParseNameAsAliases() {
        Element element = CURRENT_ELEMENT.get();
        try {
            boolean bl = element == null || !element.hasAttribute("id");
            return bl;
        }
        finally {
            CURRENT_ELEMENT.remove();
        }
    }

    protected Class<?> getBeanClass(Element element) {
        if (NamespaceUtils.isAttributeDefined(element, "name")) {
            return Queue.class;
        }
        return AnonymousQueue.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (!NamespaceUtils.isAttributeDefined(element, "name") && !NamespaceUtils.isAttributeDefined(element, "id")) {
            parserContext.getReaderContext().error("Queue must have either id or name (or both)", (Object)element);
        }
        NamespaceUtils.addConstructorArgValueIfAttributeDefined(builder, element, "name");
        if (!NamespaceUtils.isAttributeDefined(element, "name")) {
            if (this.attributeHasIllegalOverride(element, DURABLE_ATTRIBUTE, "false") || this.attributeHasIllegalOverride(element, EXCLUSIVE_ATTRIBUTE, "true") || this.attributeHasIllegalOverride(element, AUTO_DELETE_ATTRIBUTE, "true")) {
                parserContext.getReaderContext().error("Anonymous queue cannot specify durable='true', exclusive='false' or auto-delete='false'", (Object)element);
            }
            NamespaceUtils.addConstructorArgRefIfAttributeDefined(builder, element, NAMING_STRATEGY);
        } else {
            if (StringUtils.hasText((String)element.getAttribute(NAMING_STRATEGY))) {
                parserContext.getReaderContext().error("Only one of 'name' or 'naming-strategy' is allowed", (Object)element);
            }
            NamespaceUtils.addConstructorArgBooleanValueIfAttributeDefined(builder, element, DURABLE_ATTRIBUTE, false);
            NamespaceUtils.addConstructorArgBooleanValueIfAttributeDefined(builder, element, EXCLUSIVE_ATTRIBUTE, false);
            NamespaceUtils.addConstructorArgBooleanValueIfAttributeDefined(builder, element, AUTO_DELETE_ATTRIBUTE, false);
        }
        this.parseArguments(element, parserContext, builder);
        NamespaceUtils.parseDeclarationControls(element, builder);
        CURRENT_ELEMENT.set(element);
    }

    private void parseArguments(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String queueArguments = element.getAttribute(ARGUMENTS);
        Element argumentsElement = DomUtils.getChildElementByTagName((Element)element, (String)ARGUMENTS);
        if (argumentsElement != null) {
            if (StringUtils.hasText((String)queueArguments)) {
                parserContext.getReaderContext().error("Queue may have either a queue-attributes attribute or element, but not both", (Object)element);
            }
            String ref = argumentsElement.getAttribute(REF_ATTRIBUTE);
            Map map = parserContext.getDelegate().parseMapElement(argumentsElement, (BeanDefinition)builder.getRawBeanDefinition());
            if (StringUtils.hasText((String)ref)) {
                if (map != null && !map.isEmpty()) {
                    parserContext.getReaderContext().error("You cannot have both a 'ref' and a nested map", (Object)element);
                }
                builder.addConstructorArgReference(ref);
            } else {
                builder.addConstructorArgValue((Object)map);
            }
        }
        if (StringUtils.hasText((String)queueArguments)) {
            builder.addConstructorArgReference(queueArguments);
        }
    }

    private boolean attributeHasIllegalOverride(Element element, String name, String allowed) {
        return element.getAttributeNode(name) != null && element.getAttributeNode(name).getSpecified() && !allowed.equals(element.getAttribute(name));
    }
}

