/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.scalar;

import com.scalar.maven.webjar.ScalarProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public abstract class AbstractScalarController {
    protected final ScalarProperties scalarProperties;
    protected final String originalScalarUrl;

    protected AbstractScalarController(ScalarProperties scalarProperties) {
        this.scalarProperties = scalarProperties;
        this.originalScalarUrl = scalarProperties.getUrl();
    }

    protected ResponseEntity<String> getDocs(String requestUrl) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/resources/webjars/scalar/index.html");
        if (inputStream == null) {
            return ResponseEntity.notFound().build();
        }
        String html = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        requestUrl = this.decode(requestUrl);
        String cdnUrl = this.buildJsBundleUrl(requestUrl);
        String injectedHtml = html.replace("__JS_BUNDLE_URL__", cdnUrl).replace("__CONFIGURATION__", "    {\n      url: \"%s\"\n    }\n".formatted(this.buildApiDocsUrl(requestUrl)));
        return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)injectedHtml);
    }

    protected ResponseEntity<byte[]> getScalarJs() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/resources/webjars/scalar/scalar.js");
        if (inputStream == null) {
            return ResponseEntity.notFound().build();
        }
        byte[] jsContent = inputStream.readAllBytes();
        return ResponseEntity.ok().contentType(MediaType.valueOf((String)"application/javascript")).body((Object)jsContent);
    }

    protected String decode(String requestURI) {
        return URLDecoder.decode(requestURI, StandardCharsets.UTF_8);
    }

    protected String buildApiDocsUrl(String requestUrl, String apiDocsPath) {
        Object apiDocsUrl = this.scalarProperties.getUrl();
        if ("https://cdn.jsdelivr.net/npm/@scalar/galaxy/dist/latest.json".equals(this.originalScalarUrl)) {
            String serverUrl = requestUrl.substring(0, requestUrl.length() - this.scalarProperties.getPath().length());
            apiDocsUrl = serverUrl + apiDocsPath;
        }
        return apiDocsUrl;
    }

    protected String buildJsBundleUrl(String requestUrl, String scalarPath) {
        if ("https://cdn.jsdelivr.net/npm/@scalar/galaxy/dist/latest.json".equals(this.originalScalarUrl)) {
            String path;
            int firstPathSlash = requestUrl.indexOf(47, requestUrl.indexOf("://") + 3);
            String string = path = firstPathSlash >= 0 ? requestUrl.substring(firstPathSlash) : "/";
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path + "/scalar.js";
        }
        return scalarPath + "/scalar.js";
    }

    protected abstract String buildApiDocsUrl(String var1);

    protected abstract String buildJsBundleUrl(String var1);
}

