/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.redis.config;

import org.springblade.core.redis.cache.BladeRedis;
import org.springblade.core.redis.pubsub.RPubSubListenerDetector;
import org.springblade.core.redis.pubsub.RPubSubPublisher;
import org.springblade.core.redis.pubsub.RedisPubSubPublisher;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;

@AutoConfiguration
public class RedisPubSubConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        return container;
    }

    @Bean
    public RPubSubPublisher topicEventPublisher(BladeRedis bladeRedis, RedisSerializer<Object> redisSerializer) {
        return new RedisPubSubPublisher(bladeRedis, redisSerializer);
    }

    @Bean
    @ConditionalOnBean(value={RedisSerializer.class})
    public RPubSubListenerDetector topicListenerDetector(RedisMessageListenerContainer redisMessageListenerContainer, RedisSerializer<Object> redisSerializer) {
        return new RPubSubListenerDetector(redisMessageListenerContainer, redisSerializer);
    }
}

