/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.redis.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.boot.convert.DurationStyle;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class RedisAutoCacheManager
extends RedisCacheManager {
    public RedisAutoCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations, boolean allowInFlightCacheCreation) {
        super(cacheWriter, defaultCacheConfiguration, initialCacheConfigurations, allowInFlightCacheCreation);
    }

    @NonNull
    protected RedisCache createRedisCache(@NonNull String name, @Nullable RedisCacheConfiguration cacheConfig) {
        if (StringUtil.isBlank((CharSequence)name) || !name.contains("#")) {
            return super.createRedisCache(name, cacheConfig);
        }
        String[] cacheArray = name.split("#");
        if (cacheArray.length < 2) {
            return super.createRedisCache(name, cacheConfig);
        }
        String cacheName = cacheArray[0];
        if (cacheConfig != null) {
            Duration cacheAge = DurationStyle.detectAndParse((String)cacheArray[1], (ChronoUnit)ChronoUnit.SECONDS);
            cacheConfig = cacheConfig.entryTtl(cacheAge);
        }
        return super.createRedisCache(cacheName, cacheConfig);
    }
}

