/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.adapter;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springaicommunity.mcp.annotation.McpArg;
import org.springaicommunity.mcp.annotation.McpPrompt;

public class PromptAdapter {
    private PromptAdapter() {
    }

    public static McpSchema.Prompt asPrompt(McpPrompt mcpPrompt) {
        return new McpSchema.Prompt(mcpPrompt.name(), mcpPrompt.description(), List.of());
    }

    public static McpSchema.Prompt asPrompt(McpPrompt mcpPrompt, Method method) {
        List<McpSchema.PromptArgument> arguments = PromptAdapter.extractPromptArguments(method);
        return new McpSchema.Prompt(PromptAdapter.getName(mcpPrompt, method), mcpPrompt.description(), arguments);
    }

    private static String getName(McpPrompt promptAnnotation, Method method) {
        Assert.notNull((Object)method, (String)"method cannot be null");
        if (promptAnnotation == null || promptAnnotation.name() == null || promptAnnotation.name().isEmpty()) {
            return method.getName();
        }
        return promptAnnotation.name();
    }

    private static List<McpSchema.PromptArgument> extractPromptArguments(Method method) {
        Parameter[] parameters;
        ArrayList<McpSchema.PromptArgument> arguments = new ArrayList<McpSchema.PromptArgument>();
        for (Parameter parameter : parameters = method.getParameters()) {
            if (McpAsyncServerExchange.class.isAssignableFrom(parameter.getType()) || McpSchema.GetPromptRequest.class.isAssignableFrom(parameter.getType()) || Map.class.isAssignableFrom(parameter.getType())) continue;
            McpArg mcpArg = parameter.getAnnotation(McpArg.class);
            if (mcpArg != null) {
                String name = !mcpArg.name().isEmpty() ? mcpArg.name() : parameter.getName();
                arguments.add(new McpSchema.PromptArgument(name, mcpArg.description(), Boolean.valueOf(mcpArg.required())));
                continue;
            }
            arguments.add(new McpSchema.PromptArgument(parameter.getName(), "Parameter of type " + parameter.getType().getSimpleName(), Boolean.valueOf(false)));
        }
        return arguments;
    }

    private static interface McpAsyncServerExchange {
    }
}

