/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.maven.bootstrap.MavenProjectConverter;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;

public class ScannerBootstrapper {
    private final Log log;
    private final MavenSession session;
    private final EmbeddedScanner scanner;
    private final MavenProjectConverter mavenProjectConverter;
    private String serverVersion;
    private PropertyDecryptor propertyDecryptor;

    public ScannerBootstrapper(Log log, MavenSession session, EmbeddedScanner scanner, MavenProjectConverter mavenProjectConverter, PropertyDecryptor propertyDecryptor) {
        this.log = log;
        this.session = session;
        this.scanner = scanner;
        this.mavenProjectConverter = mavenProjectConverter;
        this.propertyDecryptor = propertyDecryptor;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.applyMasks();
            this.scanner.start();
            this.serverVersion = this.scanner.serverVersion();
            this.checkSQVersion();
            if (this.log.isDebugEnabled()) {
                this.scanner.setGlobalProperty("sonar.verbose", "true");
            }
            this.scanner.execute(this.collectProperties());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void applyMasks() {
        this.scanner.mask("org.slf4j.LoggerFactory");
        this.scanner.unmask("org.slf4j.Logger");
        this.scanner.unmask("org.slf4j.ILoggerFactory");
        this.scanner.unmask("org.slf4j.Marker");
        this.scanner.mask("org.slf4j.");
        this.scanner.mask("ch.qos.logback.");
        this.scanner.mask("org.sonar.");
        this.scanner.mask("com.google.common");
        this.scanner.unmask("");
    }

    private Map<String, String> collectProperties() throws MojoExecutionException {
        List sortedProjects = this.session.getProjects();
        MavenProject topLevelProject = null;
        for (MavenProject project : sortedProjects) {
            if (!project.isExecutionRoot()) continue;
            topLevelProject = project;
            break;
        }
        if (topLevelProject == null) {
            throw new IllegalStateException("Maven session does not declare a top level project");
        }
        Map<String, String> props = this.mavenProjectConverter.configure(sortedProjects, topLevelProject, this.session.getUserProperties());
        props.putAll(this.propertyDecryptor.decryptProperties(props));
        return props;
    }

    private void checkSQVersion() {
        if (this.serverVersion != null) {
            this.log.info((CharSequence)("SonarQube version: " + this.serverVersion));
        }
        if (this.isVersionPriorTo("5.6")) {
            throw new UnsupportedOperationException("With SonarQube server prior to 5.6, it is recommended to use the sonar-maven-plugin 3.3");
        }
    }

    boolean isVersionPriorTo(String version) {
        if (this.serverVersion == null) {
            return true;
        }
        return new ComparableVersion(this.serverVersion).compareTo(new ComparableVersion(version)) < 0;
    }
}

