/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.orcid.OrcidProfile;
import org.pac4j.oauth.profile.orcid.OrcidProfileDefinition;
import org.pac4j.scribe.builder.api.OrcidApi20;

public class OrcidClient
extends OAuth20Client<OrcidProfile> {
    protected static final String DEFAULT_SCOPE = "/orcid-profile/read-limited";
    protected String scope = "/orcid-profile/read-limited";

    public OrcidClient() {
    }

    public OrcidClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit(WebContext context) {
        this.configuration.setApi(new OrcidApi20());
        this.configuration.setProfileDefinition(new OrcidProfileDefinition());
        this.configuration.setScope(this.scope);
        this.configuration.setHasGrantType(true);
        this.configuration.setTokenAsHeader(true);
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error");
            String errorDescription = ctx.getRequestParameter("error_description");
            if ("access_denied".equals(error) && "User denied access".equals(errorDescription)) {
                return true;
            }
            return false;
        });
        this.setConfiguration(this.configuration);
        super.clientInit(context);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

