/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.cache.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.cache.CacheService;
import org.osgl.cache.CacheServiceProvider;
import org.osgl.cache.impl.SimpleCacheService;

public class SimpleCacheServiceProvider
implements CacheServiceProvider {
    public static SimpleCacheServiceProvider INSTANCE = new SimpleCacheServiceProvider();
    private static ConcurrentMap<String, CacheService> services = new ConcurrentHashMap<String, CacheService>();

    @Override
    public CacheService get() {
        return this.get("osgl-cache");
    }

    @Override
    public CacheService get(String name) {
        CacheService cs = (CacheService)services.get(name);
        if (null == cs) {
            cs = new SimpleCacheService(name);
            services.putIfAbsent(name, cs);
        }
        return cs;
    }

    @Override
    public void reset() {
        for (CacheService service : services.values()) {
            service.shutdown();
        }
        services.clear();
    }
}

