/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.cache.impl;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgl.$;
import org.osgl.cache.impl.CacheServiceBase;
import org.osgl.logging.L;
import org.osgl.logging.Logger;

public class SimpleCacheService
extends CacheServiceBase {
    private String name;
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this._lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this._lock.writeLock();
    private static final Logger logger = L.get(SimpleCacheService.class);
    private ScheduledExecutorService scheduler = null;
    private Map<String, SoftItem> cache_ = new WeakHashMap<String, SoftItem>();
    private Queue<SoftItem> items_ = new PriorityQueue<SoftItem>();
    private int defaultTTL = 60;

    SimpleCacheService(String name) {
        this.name = name;
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object value, int ttl) {
        if (null == key) {
            throw new NullPointerException();
        }
        if (0 >= ttl) {
            ttl = this.defaultTTL;
        }
        this.writeLock.lock();
        try {
            Item item1;
            SoftItem item = this.cache_.get(key);
            Item item2 = item1 = null == item ? null : (Item)item.get();
            if (null == item1) {
                SoftItem newItem = new SoftItem(key, value, ttl);
                this.cache_.put(key, newItem);
                this.items_.offer(newItem);
            } else {
                item1.value = value;
                item1.ttl = ttl;
                item1.ts = $.ms();
                this.items_.remove(item);
                this.items_.offer(item);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key) {
        this.readLock.lock();
        try {
            SoftItem item = this.cache_.get(key);
            if (null == item) {
                T t = null;
                return t;
            }
            Item item1 = (Item)item.get();
            Object object = null == item1 ? null : item1.value;
            return (T)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void put(String key, Object value) {
        this.put(key, value, this.defaultTTL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(String key) {
        this.writeLock.lock();
        try {
            this.cache_.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            this.cache_.clear();
            this.items_.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setDefaultTTL(int ttl) {
        if (ttl == 0) {
            throw new IllegalArgumentException("time to live value couldn't be zero");
        }
        this.defaultTTL = ttl;
    }

    @Override
    protected synchronized void internalShutdown() {
        this.clear();
        if (null != this.scheduler) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    @Override
    protected synchronized void internalStartup() {
        if (null == this.scheduler) {
            this.scheduler = new ScheduledThreadPoolExecutor(1, new TimerThreadFactory(this.name));
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block10: {
                        if (SimpleCacheService.this.items_.isEmpty()) {
                            return;
                        }
                        boolean trace = logger.isTraceEnabled();
                        long now = System.currentTimeMillis();
                        if (trace) {
                            logger.trace(">>>>now:%s", new Object[]{now});
                        }
                        SimpleCacheService.this.writeLock.lock();
                        try {
                            long ts;
                            while (true) {
                                SoftItem item0;
                                if (null == (item0 = (SoftItem)SimpleCacheService.this.items_.peek())) {
                                    break block10;
                                }
                                Item item = (Item)item0.get();
                                if (null == item) {
                                    SimpleCacheService.this.items_.poll();
                                    continue;
                                }
                                ts = item.ts + (long)(item.ttl * 1000);
                                if (ts < now + 50L) {
                                    SimpleCacheService.this.cache_.remove(item.key);
                                    SimpleCacheService.this.items_.poll();
                                    if (!trace) continue;
                                    logger.trace("- %s at %s", new Object[]{item.key, ts});
                                    continue;
                                }
                                if (SimpleCacheService.this.cache_.containsKey(item.key)) break;
                                SimpleCacheService.this.items_.poll();
                                if (!trace) continue;
                                logger.trace("cached item evicted: %s", new Object[]{item.key});
                            }
                            if (trace) {
                                logger.trace(">>>>ts:  %s", new Object[]{ts});
                            }
                        }
                        finally {
                            SimpleCacheService.this.writeLock.unlock();
                        }
                    }
                }
            }, 0L, 100L, TimeUnit.MILLISECONDS);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SimpleCacheService.this.shutdown();
                }
            });
        }
    }

    private static class SoftItem
    extends SoftReference<Item>
    implements Comparable<SoftItem> {
        public SoftItem(String key, Object value, int ttl) {
            super(new Item(key, value, ttl));
        }

        @Override
        public int compareTo(SoftItem that) {
            if (null == that) {
                return 1;
            }
            Item myItem = (Item)this.get();
            if (null == myItem) {
                return -1;
            }
            Item hisItem = (Item)that.get();
            return myItem.compareTo(hisItem);
        }
    }

    private static class Item
    implements Comparable<Item> {
        String key;
        Object value;
        long ts;
        int ttl;

        Item(String key, Object value, int ttl) {
            this.key = key;
            this.value = value;
            this.ttl = ttl;
            this.ts = $.ms();
        }

        @Override
        public int compareTo(Item that) {
            if (null == that) {
                return 1;
            }
            long myTs = this.ts + (long)(this.ttl * 1000);
            long hisTs = that.ts + (long)(that.ttl * 1000);
            return myTs < hisTs ? -1 : (myTs > hisTs ? 1 : this.key.compareTo(that.key));
        }
    }

    private static class TimerThreadFactory
    implements ThreadFactory {
        private String name;
        private static final AtomicInteger threadNumber = new AtomicInteger(1);

        TimerThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            SecurityManager s = System.getSecurityManager();
            ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            Thread t = new Thread(group, r, "simple-cache-service-" + threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

