/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.cache.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.osgl.cache.CacheServiceProvider;
import org.osgl.cache.impl.CacheServiceBase;
import org.osgl.cache.impl.MemcachedClientConfigurator;
import org.osgl.exception.ConfigurationException;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.S;

public class MemcachedService
extends CacheServiceBase {
    private static Logger logger = L.get(MemcachedService.class);
    private static MemcachedService instance;
    private MemcachedClient client;
    private SerializingTranscoder tc = new SerializingTranscoder(){

        protected Object deserialize(byte[] data) {
            try {
                return new ObjectInputStream(new ByteArrayInputStream(data)){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        return Class.forName(desc.getName(), false, CacheServiceProvider.Impl.classLoader());
                    }
                }.readObject();
            }
            catch (Exception e) {
                logger.error((Throwable)e, "Could not deserialize");
                return null;
            }
        }

        protected byte[] serialize(Object object) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                new ObjectOutputStream(bos).writeObject(object);
                return bos.toByteArray();
            }
            catch (IOException e) {
                logger.error((Throwable)e, "Could not serialize");
                return null;
            }
        }
    };
    private int defaultTTL = 60;

    public static MemcachedService getInstance() {
        return MemcachedService.getInstance(false);
    }

    public static MemcachedService getInstance(boolean forceClientInit) {
        try {
            if (null == instance) {
                instance = new MemcachedService();
            } else if (forceClientInit) {
                Thread.interrupted();
                instance.initClient();
            }
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        return instance;
    }

    private MemcachedService() throws IOException {
        this.initClient();
    }

    public void initClient() throws IOException {
        System.setProperty("net.spy.log.LoggerImpl", "org.osgl.cache.impl.SpyMemcachedLogger");
        List<InetSocketAddress> addrs = MemcachedClientConfigurator.getHosts();
        if (addrs.isEmpty()) {
            throw new ConfigurationException("Bad configuration for memcached: missing host(s)");
        }
        String username = MemcachedClientConfigurator.getUsername();
        if (S.notBlank((String)username)) {
            String password = MemcachedClientConfigurator.getPassword();
            if (null == password) {
                throw new ConfigurationException("Bad configuration for memcached: missing password");
            }
            AuthDescriptor ad = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(username, password));
            ConnectionFactory cf = new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setAuthDescriptor(ad).build();
            this.client = new MemcachedClient(cf, addrs);
        } else {
            this.client = new MemcachedClient(addrs);
        }
    }

    public void put(String key, Object value, int ttl) {
        this.client.set(key, ttl, value, (Transcoder)this.tc);
    }

    public void put(String key, Object value) {
        this.client.set(key, this.defaultTTL, value);
    }

    public void evict(String key) {
        this.client.delete(key);
    }

    public <T> T get(String key) {
        GetFuture future = this.client.asyncGet(key, (Transcoder)this.tc);
        try {
            return (T)future.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(false);
            return null;
        }
    }

    public void clear() {
        this.client.flush();
    }

    public void setDefaultTTL(int ttl) {
        if (ttl <= 0) {
            throw new IllegalArgumentException("time to live value couldn't be zero or negative number");
        }
        this.defaultTTL = ttl;
    }

    @Override
    protected synchronized void internalShutdown() {
        if (null != this.client) {
            this.client.shutdown();
            this.client = null;
        }
        instance = null;
    }

    @Override
    protected synchronized void internalStartup() {
        if (null == this.client) {
            try {
                this.initClient();
            }
            catch (IOException e) {
                throw E.ioException((IOException)e);
            }
        }
    }
}

