/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.cache.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.spy.memcached.AddrUtil;
import org.osgl.cache.impl.MemcachedService;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.S;

public class MemcachedClientConfigurator {
    protected static final Logger logger = L.get(MemcachedClientConfigurator.class);
    public static final String CONF_FILE = "memcached.properties";
    private static volatile Config conf = null;

    private static void autoConfig() {
        Properties prop = new Properties();
        try {
            URL url = null;
            url = Thread.currentThread().getContextClassLoader().getResource(CONF_FILE);
            if (null == url) {
                url = MemcachedClientConfigurator.class.getResource(CONF_FILE);
            }
            if (null == url) {
                logger.warn("Cannot find memcached.properties in class path");
            } else {
                prop.load(url.openStream());
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e, "error loading memcached client configuration file: memcached.properties");
        }
        prop.putAll((Map<?, ?>)System.getProperties());
        Config conf = new Config();
        if (prop.containsKey("memcached.host")) {
            String s = prop.getProperty("memcached.host");
            if (!s.contains(":")) {
                s = s + ":11211";
            }
            conf.hosts = AddrUtil.getAddresses((String)s);
        } else {
            int n = 1;
            String addresses = "";
            while (prop.containsKey("memcached." + n + ".host")) {
                String s = prop.getProperty("memcached." + n + ".host");
                if (!s.contains(":")) {
                    s = s + ":11211";
                }
                addresses = addresses + s + " ";
            }
            if (S.notBlank((String)addresses)) {
                conf.hosts = AddrUtil.getAddresses((String)addresses);
            }
        }
        if (prop.containsKey("memcached.user")) {
            conf.username = prop.getProperty("memcached.user");
        } else if (prop.containsKey("memcached.username")) {
            conf.username = prop.getProperty("memcached.username");
        }
        conf.password = prop.getProperty("memcached.password");
        MemcachedClientConfigurator.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Config conf() {
        if (null != conf) return conf;
        Class<MemcachedClientConfigurator> clazz = MemcachedClientConfigurator.class;
        synchronized (MemcachedClientConfigurator.class) {
            if (null != conf) return conf;
            MemcachedClientConfigurator.autoConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return conf;
        }
    }

    public static void setHosts(String addr1, String ... addrs) {
        String addr = S.join((String)" ", (String[])new String[]{addr1, S.join((String)" ", (String[])addrs)});
        MemcachedClientConfigurator.conf().hosts = AddrUtil.getAddresses((String)addr);
    }

    public static void setUsernamePassword(String username, String password) {
        MemcachedClientConfigurator.conf().username = username;
        MemcachedClientConfigurator.conf().password = password;
    }

    public static List<InetSocketAddress> getHosts() {
        return MemcachedClientConfigurator.conf().hosts;
    }

    public static String getUsername() {
        return MemcachedClientConfigurator.conf().username;
    }

    public static String getPassword() {
        return MemcachedClientConfigurator.conf().password;
    }

    public static void applyConfig() throws IOException {
        MemcachedService.getInstance(true);
    }

    private static class Config {
        private List<InetSocketAddress> hosts = new ArrayList<InetSocketAddress>();
        private String username;
        private String password;

        private Config() {
        }
    }
}

