/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly;

import edu.mit.simile.butterfly.ButterflyModule;
import edu.mit.simile.butterfly.MountPoint;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkRewriter
extends PrintWriter {
    private static final Logger _logger = LoggerFactory.getLogger((String)"butterfly.link_rewriter");
    private ButterflyModule _module;
    private PrintWriter _writer;
    private char[] _baseURL;
    private State _state = State.START;
    private int _start = -1;
    private int _end = -1;
    private StringBuffer _buffer = new StringBuffer(128);

    public LinkRewriter(PrintWriter writer, ButterflyModule module) {
        this(writer, module, null);
    }

    public LinkRewriter(PrintWriter writer, ButterflyModule module, String baseURL) {
        super(writer);
        this._writer = writer;
        this._module = module;
        this._baseURL = baseURL == null ? null : baseURL.toCharArray();
    }

    @Override
    public void write(char[] buf, int off, int len) {
        _logger.trace("write char[] {} {}", (Object)off, (Object)len);
        if (off >= buf.length) {
            return;
        }
        len = Math.min(off + len, buf.length) - off;
        for (int i = off; i < off + len; ++i) {
            char c = buf[i];
            _logger.trace("'{}'", (Object)Character.valueOf(c));
            if (this._state == State.START) {
                if (c != '[') continue;
                _logger.trace("start -> opening");
                this._state = State.OPENING;
                this._start = i;
                continue;
            }
            if (this._state == State.OPENING) {
                if (c == '#') {
                    _logger.trace("opening -> opened");
                    this._state = State.OPENED;
                    continue;
                }
                _logger.trace("opening -> start");
                this._state = State.START;
                continue;
            }
            if (this._state == State.OPENED) {
                if (c == '#') {
                    _logger.trace("opened -> closing");
                    this._state = State.CLOSING;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                _logger.trace("opened -> start");
                this._state = State.START;
                continue;
            }
            if (this._state == State.CLOSING) {
                if (c == ']') {
                    _logger.trace("closing -> closed");
                    this._state = State.CLOSED;
                    continue;
                }
                _logger.trace("closing -> start");
                this._state = State.START;
                continue;
            }
            if (this._state != State.CLOSED) continue;
            this._end = i - 1;
            if (c == '/') {
                _logger.trace("closed -> slashed");
                this._state = State.SLASHED;
                break;
            }
            _logger.trace("closed -> unslashed");
            this._state = State.UNSLASHED;
            break;
        }
        if (this._state == State.START) {
            _logger.trace("pass along");
            int l = this._buffer.length();
            if (l > 0) {
                char[] b = new char[l];
                this._buffer.getChars(0, l, b, 0);
                this._writer.write(b, 0, l);
                this._buffer.setLength(0);
            }
            this._writer.write(buf, off, len);
        } else if (this._state == State.SLASHED || this._state == State.UNSLASHED) {
            MountPoint mountPoint;
            boolean slashed = this._state == State.SLASHED;
            this._state = State.START;
            _logger.trace("closed");
            if (this._buffer.length() > 0) {
                int l = this._buffer.length();
                _logger.trace("with leftovers: {}", (Object)l);
                this._buffer.append(buf, off, len);
                len = this._buffer.length();
                buf = new char[len];
                off = 0;
                this._end += l;
                this._buffer.getChars(0, len, buf, 0);
                this._buffer.setLength(0);
            }
            _logger.trace("{} {}", (Object)this._start, (Object)this._end);
            String name = new String(buf, this._start + 2, this._end - this._start - 3);
            _logger.trace("name: {}", (Object)name);
            ButterflyModule module = this._module.getModule(name);
            MountPoint mountPoint2 = mountPoint = module == null ? null : module.getMountPoint();
            if (mountPoint != null) {
                _logger.trace("module found");
                this._writer.write(buf, off, this._start - off);
                if (this._baseURL != null) {
                    this._writer.write(this._baseURL, 0, this._baseURL.length);
                }
                char[] mountPointChars = mountPoint.getMountPoint().toCharArray();
                this._writer.write(mountPointChars, 0, slashed ? mountPointChars.length - 1 : mountPointChars.length);
                this.write(buf, this._end + 1, off + len - this._end - 1);
            } else {
                _logger.info("module NOT found");
                this._writer.write(buf, off, this._end - off);
                this.write(buf, this._end, len - (this._end - off));
            }
        } else {
            if (this._buffer.length() == 0) {
                this._start -= off;
            }
            this._buffer.append(buf, off, len);
            _logger.trace("saved leftovers: {} {}", (Object)this._buffer.length(), (Object)this._start);
        }
    }

    @Override
    public void write(char[] buf) {
        _logger.trace("write char[]");
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(String s) {
        _logger.trace("write string");
        this.write(s.toCharArray(), 0, s.length());
    }

    @Override
    public void write(String s, int off, int len) {
        _logger.trace("write string off len");
        this.write(s.toCharArray(), off, len);
    }

    @Override
    public void write(int c) {
        _logger.trace("write int");
        this.write(new char[]{(char)c}, 0, 1);
    }

    public static enum State {
        START,
        OPENING,
        OPENED,
        CLOSING,
        CLOSED,
        SLASHED,
        UNSLASHED;

    }
}

