/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly;

import com.metaweb.lessen.Utilities;
import com.metaweb.lessen.tokenizers.CondensingTokenizer;
import com.metaweb.lessen.tokenizers.IndentingTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import edu.mit.simile.butterfly.Butterfly;
import edu.mit.simile.butterfly.ButterflyModule;
import edu.mit.simile.butterfly.ButterflyMounter;
import edu.mit.simile.butterfly.ButterflyScope;
import edu.mit.simile.butterfly.ButterflyScriptableObject;
import edu.mit.simile.butterfly.LinkRewriter;
import edu.mit.simile.butterfly.MountPoint;
import edu.mit.simile.butterfly.ScriptableButterfly;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButterflyModuleImpl
implements ButterflyModule {
    protected static final Logger _logger = LoggerFactory.getLogger((String)"butterfly.module");
    protected ClassLoader _classLoader;
    protected Timer _timer;
    protected ServletConfig _config;
    protected File _path;
    protected Path _normalizedPath;
    protected MountPoint _mountPoint;
    protected ButterflyMounter _mounter;
    protected String _name;
    protected File _tempDir;
    protected ButterflyModule _extended;
    protected Set<ButterflyModule> _extendedBy = new LinkedHashSet<ButterflyModule>();
    protected Set<String> _implementations = new LinkedHashSet<String>();
    protected Map<String, ButterflyModule> _dependencies = new HashMap<String, ButterflyModule>();
    protected ExtendedProperties _properties;
    protected Map<String, ButterflyModule> _modules;
    protected VelocityEngine _templateEngine;
    protected OrderedMap _scripts = new ListOrderedMap();
    protected Set<ButterflyScriptableObject> _scriptables = new LinkedHashSet<ButterflyScriptableObject>();
    protected Set<TimerTask> _packers = new HashSet<TimerTask>();
    protected Pattern super_pattern = Pattern.compile("^@@(.*)@@$");
    protected Pattern images_pattern = Pattern.compile("^/?.*\\.(jpg|gif|png)$");
    protected Pattern mod_inf_pattern = Pattern.compile("^.*/MOD-INF/.*$");
    protected String encoding = "UTF-8";

    @Override
    public void init(ServletConfig config) throws Exception {
        this._config = config;
        this.scriptInit();
    }

    @Override
    public void destroy() throws Exception {
        for (ButterflyScriptableObject scriptable : this._scriptables) {
            scriptable.destroy();
        }
    }

    @Override
    public ServletConfig getServletConfig() {
        return this._config;
    }

    @Override
    public ServletContext getServletContext() {
        return this._config.getServletContext();
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        _logger.trace("{} -(classloader)-> {}", (Object)this, (Object)classLoader);
        this._classLoader = classLoader;
    }

    @Override
    public void setPath(File path) {
        _logger.trace("{} -(path)-> {}", (Object)this, (Object)path);
        this._path = path;
        this._normalizedPath = path.toPath().toAbsolutePath().normalize();
    }

    @Override
    public void setName(String name) {
        _logger.trace("{} -(name)-> {}", (Object)this, (Object)name);
        this._name = name;
    }

    @Override
    public void setExtended(ButterflyModule extended) {
        _logger.trace("{} -(extends)-> {}", (Object)this, (Object)extended);
        this._extended = extended;
    }

    @Override
    public void addExtendedBy(ButterflyModule extendedBy) {
        _logger.trace("{} -(extended by)-> {}", (Object)this, (Object)extendedBy);
        this._extendedBy.add(extendedBy);
    }

    @Override
    public void setMountPoint(MountPoint mountPoint) {
        _logger.trace("{} -(mount point)-> {}", (Object)this, (Object)mountPoint);
        this._mountPoint = mountPoint;
    }

    @Override
    public void setImplementation(String id) {
        _logger.trace("{} -(implements)-> {}", (Object)this, (Object)id);
        this._implementations.add(id);
    }

    @Override
    public void setDependency(String name, ButterflyModule module) {
        if (!this._dependencies.containsKey(name)) {
            _logger.trace("{} -({})-> {}", new Object[]{this, name, module});
            this._dependencies.put(name, module);
        }
    }

    @Override
    public void setModules(Map<String, ButterflyModule> map) {
        this._modules = map;
    }

    @Override
    public void setScript(URL url, Script script) {
        _logger.trace("{} -(script)-> {}", (Object)this, (Object)url);
        this._scripts.put((Object)url, (Object)script);
    }

    @Override
    public void setScriptable(ButterflyScriptableObject scriptable) {
        _logger.trace("{} -(scriptable)-> {}", (Object)this, (Object)scriptable.getClassName());
        this._scriptables.add(scriptable);
    }

    @Override
    public void setTemplateEngine(VelocityEngine templateEngine) {
        _logger.trace("{} gets template engine", (Object)this);
        this._templateEngine = templateEngine;
    }

    @Override
    public void setProperties(ExtendedProperties properties) {
        _logger.trace("{} gets loaded with properties", (Object)this);
        this._properties = properties;
    }

    @Override
    public void setMounter(ButterflyMounter mounter) {
        _logger.trace("{} gets the module mounter", (Object)this);
        this._mounter = mounter;
    }

    public void setTemporaryDir(File tempDir) {
        _logger.trace("{} -(tempDir)-> {}", (Object)this, (Object)tempDir);
        this._tempDir = tempDir;
        try {
            FileUtils.deleteDirectory((File)tempDir);
            tempDir.mkdirs();
        }
        catch (Exception e) {
            _logger.error("Error cleaning temporary directory", (Throwable)e);
        }
    }

    @Override
    public void setTimer(Timer timer) {
        _logger.trace("{} gets timer", (Object)this);
        this._timer = timer;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public File getPath() {
        return this._path;
    }

    @Override
    public ExtendedProperties getProperties() {
        return this._properties;
    }

    @Override
    public MountPoint getMountPoint() {
        return this._mountPoint;
    }

    @Override
    public ButterflyMounter getMounter() {
        return this._mounter;
    }

    @Override
    public ButterflyModule getExtendedModule() {
        return this._extended;
    }

    public Set<ButterflyModule> getExtendingModules() {
        return this._extendedBy;
    }

    @Override
    public Map<String, ButterflyModule> getDependencies() {
        return this._dependencies;
    }

    @Override
    public Set<String> getImplementations() {
        return this._implementations;
    }

    @Override
    public Set<ButterflyScriptableObject> getScriptables() {
        return this._scriptables;
    }

    @Override
    public VelocityEngine getTemplateEngine() {
        return this._templateEngine;
    }

    @Override
    public ButterflyModule getModule(String name) {
        _logger.trace("> getModule({}) [{}]", (Object)name, (Object)this._name);
        ButterflyModule module = this._dependencies.get(name);
        if (module == null && this._extended != null) {
            module = this._extended.getModule(name);
        }
        if (module == null) {
            module = this._modules.get(name);
        }
        _logger.trace("< getModule({}) [{}] -> {}", new Object[]{name, this._name, module});
        return module;
    }

    @Override
    public URL getResource(String resource) {
        Matcher m;
        _logger.trace("> getResource({}->{},{})", new Object[]{this._name, this._extended, resource});
        URL u = null;
        if ("".equals(resource)) {
            try {
                u = this._path.toURI().toURL();
            }
            catch (MalformedURLException e) {
                _logger.error("Error", (Throwable)e);
            }
        }
        if (u == null && resource.charAt(0) == '@' && (m = this.super_pattern.matcher(resource)).matches()) {
            resource = m.group(1);
            if (this._extended != null) {
                u = this._extended.getResource(resource);
            }
        }
        if (u == null) {
            try {
                File f;
                if (resource.charAt(0) == '/') {
                    resource = resource.substring(1);
                }
                if ((f = new File(this._path, resource)).toPath().toAbsolutePath().normalize().startsWith(this._normalizedPath) && f.exists()) {
                    u = f.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                _logger.error("Error", (Throwable)e);
            }
        }
        if (u == null && this._extended != null) {
            u = this._extended.getResource(resource);
        }
        _logger.trace("< getResource({}->{},{}) -> {}", new Object[]{this._name, this._extended, resource, u});
        return u;
    }

    @Override
    public String getRelativePath(HttpServletRequest request) {
        _logger.trace("> getRelativePath()");
        String path = request.getPathInfo();
        String mountPoint = this._mountPoint.getMountPoint();
        if (path.startsWith(mountPoint)) {
            path = path.substring(mountPoint.length());
        }
        _logger.trace("< getRelativePath() -> {}", (Object)path);
        return path;
    }

    @Override
    public PrintWriter getFilteringWriter(HttpServletRequest request, HttpServletResponse response, boolean absolute) throws IOException {
        _logger.trace("> getFilteringWriter() [{},absolute='{}']", (Object)this, (Object)absolute);
        LinkRewriter rewriter = new LinkRewriter(response.getWriter(), this, this.getContextPath(request, absolute));
        _logger.trace("< getFilteringWriter() [{},absolute='{}']", (Object)this, (Object)absolute);
        return rewriter;
    }

    @Override
    public String getContextPath(HttpServletRequest request, boolean absolute) {
        return Butterfly.getTrueContextPath(request, absolute);
    }

    @Override
    public String getString(HttpServletRequest request) throws IOException {
        BufferedReader reader = request.getReader();
        StringWriter writer = new StringWriter();
        IOUtils.copy((Reader)reader, (Writer)writer);
        writer.close();
        reader.close();
        return writer.toString();
    }

    @Override
    public File getTemporaryDir() {
        return this._tempDir;
    }

    @Override
    public boolean process(String path, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.processScript(path, request, response)) {
            return true;
        }
        Matcher m = null;
        if (path.equals("") || path.endsWith("/")) {
            return this.sendText(request, response, path + "index.html", this.encoding, "text/html", false);
        }
        if (path.endsWith(".js")) {
            return this.sendText(request, response, path, this.encoding, "text/javascript", false);
        }
        m = this.images_pattern.matcher(path);
        if (m.matches()) {
            return this.sendBinary(request, response, path, "image/" + m.group(1));
        }
        if (path.endsWith(".css")) {
            return this.sendText(request, response, path, this.encoding, "text/css", false);
        }
        if (path.endsWith(".less")) {
            return this.sendLessen(request, response, path, this.encoding, "text/css", false);
        }
        if (path.endsWith(".html")) {
            return this.sendText(request, response, path, this.encoding, "text/html", false);
        }
        if (path.endsWith(".xml")) {
            return this.sendText(request, response, path, this.encoding, "application/xml", false);
        }
        if (path.endsWith(".svg")) {
            return this.sendText(request, response, path, this.encoding, "image/svg+xml", false);
        }
        m = this.mod_inf_pattern.matcher(path);
        if (m.matches()) {
            response.sendError(403);
            return true;
        }
        return false;
    }

    @Override
    public boolean redirect(HttpServletRequest request, HttpServletResponse response, String location) throws Exception {
        _logger.trace("> redirect: {}", (Object)location);
        String redirectURL = location;
        if (!location.startsWith("http://") && !location.startsWith("https://")) {
            String contextPath = this.getContextPath(request, true);
            String servletPath = request.getServletPath();
            if ("".equals(location)) {
                location = "/";
            }
            if (servletPath != null) {
                if (servletPath.startsWith("/")) {
                    servletPath = servletPath.substring(1);
                }
                redirectURL = contextPath + servletPath + location;
            } else {
                redirectURL = contextPath + location;
            }
        }
        _logger.info("redirecting to: {}", (Object)redirectURL);
        response.sendRedirect(redirectURL);
        _logger.trace("< redirect: {}", (Object)location);
        return true;
    }

    @Override
    public boolean sendBinary(HttpServletRequest request, HttpServletResponse response, String file, String mimeType) throws Exception {
        return this.send(request, response, this.getResource(file), false, null, mimeType, null, null, false);
    }

    @Override
    public boolean sendBinary(HttpServletRequest request, HttpServletResponse response, URL resource, String mimeType) throws Exception {
        return this.send(request, response, resource, false, null, mimeType, null, null, false);
    }

    @Override
    public boolean sendText(HttpServletRequest request, HttpServletResponse response, String file, String encoding, String mimeType, boolean absolute) throws Exception {
        return this.send(request, response, this.getResource(file), true, encoding, mimeType, null, null, absolute);
    }

    @Override
    public boolean sendText(HttpServletRequest request, HttpServletResponse response, URL resource, String encoding, String mimeType, boolean absolute) throws Exception {
        return this.send(request, response, resource, true, encoding, mimeType, null, null, absolute);
    }

    @Override
    public boolean sendWrappedText(HttpServletRequest request, HttpServletResponse response, URL resource, String encoding, String mimeType, String prologue, String epilogue, boolean absolute) throws Exception {
        return this.send(request, response, resource, true, encoding, mimeType, prologue, epilogue, absolute);
    }

    @Override
    public boolean sendTextFromTemplate(HttpServletRequest request, HttpServletResponse response, VelocityContext velocity, String template, String encoding, String mimeType, boolean absolute) throws Exception {
        _logger.trace("> template {} [{}|{}]", (Object[])new String[]{template, encoding, mimeType});
        try {
            response.setContentType(mimeType);
            this._templateEngine.mergeTemplate(template, encoding, (Context)velocity, (Writer)this.getFilteringWriter(request, response, absolute));
        }
        catch (ResourceNotFoundException e) {
            response.sendError(404);
        }
        _logger.trace("< template {} [{}|{}]", (Object[])new String[]{template, encoding, mimeType});
        return true;
    }

    public boolean sendLessen(HttpServletRequest request, HttpServletResponse response, String path, String encoding, String mimeType, boolean absolute) throws Exception {
        URL url = this.getResource(path);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("module", this._name);
        Tokenizer tokenizer = Utilities.openLess((URL)url, variables);
        tokenizer = new CondensingTokenizer(tokenizer, false);
        tokenizer = new IndentingTokenizer(tokenizer);
        return this.sendLessenTokenStream(request, response, tokenizer, encoding, "text/css", false);
    }

    public boolean sendLessenTokenStream(HttpServletRequest request, HttpServletResponse response, Tokenizer tokenizer, String encoding, String mimeType, boolean absolute) throws Exception {
        try {
            response.setContentType(mimeType);
            Utilities.write((Tokenizer)tokenizer, (Writer)this.getFilteringWriter(request, response, absolute));
        }
        catch (ResourceNotFoundException e) {
            response.sendError(404);
        }
        return true;
    }

    @Override
    public boolean sendString(HttpServletRequest request, HttpServletResponse response, String str, String encoding, String mimeType) throws Exception {
        _logger.trace("> string: '{}'", (Object)str);
        response.setContentType(mimeType);
        response.setCharacterEncoding(encoding);
        PrintWriter writer = response.getWriter();
        writer.write(str);
        writer.close();
        _logger.trace("< string: '{}'", (Object)str);
        return true;
    }

    @Override
    public boolean sendError(HttpServletRequest request, HttpServletResponse response, int code, String str) throws Exception {
        _logger.trace("> error: '{}' '{}'", (Object)code, (Object)str);
        response.sendError(code, str);
        _logger.trace("< error: '{}' '{}'", (Object)code, (Object)str);
        return true;
    }

    @Override
    public List<Level> makePath(String path, Map<String, String> descs) {
        LinkedList<Level> ls = new LinkedList<Level>();
        String[] paths = path.split("/");
        if (paths.length > 1) {
            String relativePath = path.endsWith("/") ? "../" : "./";
            for (int i = paths.length - 2; i >= 0; --i) {
                String p = paths[i];
                String desc = descs.get(paths[i]);
                if (desc == null) {
                    desc = p;
                }
                Level l = new Level(desc, relativePath);
                relativePath = "../" + relativePath;
                ls.addFirst(l);
            }
        }
        return ls;
    }

    public String toString() {
        return this._name + " [" + this.getClass().getName() + "]";
    }

    @Override
    public void initScope(org.mozilla.javascript.Context context, Scriptable scope) {
        for (ButterflyModule m : this._dependencies.values()) {
            m.initScope(context, scope);
        }
        OrderedMapIterator i = this._scripts.orderedMapIterator();
        while (i.hasNext()) {
            URL url = (URL)i.next();
            _logger.debug("Executing script: {}", (Object)url);
            Script s = (Script)this._scripts.get((Object)url);
            s.exec(context, scope);
        }
    }

    protected void scriptInit() throws Exception {
        org.mozilla.javascript.Context context = ContextFactory.getGlobal().enterContext();
        ButterflyScope scope = new ButterflyScope(this, context);
        this.initScope(context, (Scriptable)scope);
        String functionName = "init";
        try {
            Object fun = context.compileString(functionName, null, 1, null).exec(context, (Scriptable)scope);
            if (fun != null && fun instanceof Function) {
                try {
                    ((Function)fun).call(context, (Scriptable)scope, (Scriptable)scope, new Object[0]);
                }
                catch (EcmaError ee) {
                    _logger.error("Error initializing module " + this.getName() + " by script function init()", (Throwable)ee);
                }
            }
        }
        catch (EcmaError ecmaError) {
            // empty catch block
        }
    }

    protected boolean processScript(String path, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean result = false;
        if (this._scripts.size() > 0) {
            Controller controller = new Controller(path, request, response);
            ContextFactory.getGlobal().call((ContextAction)controller);
            result = controller.didRespond();
        }
        if (!result && this._extended != null && this._extended instanceof ButterflyModuleImpl) {
            result = ((ButterflyModuleImpl)this._extended).processScript(path, request, response);
        }
        return result;
    }

    protected ButterflyScope getScope(org.mozilla.javascript.Context context, HttpServletRequest request) throws Exception {
        return new ButterflyScope(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean send(HttpServletRequest request, HttpServletResponse response, URL resource, boolean filtering, String encoding, String mimeType, String prologue, String epilogue, boolean absolute) throws Exception {
        ButterflyModuleImpl._logger.trace("> send {}", (Object)resource);
        if (resource != null) {
            urlConnection = resource.openConnection();
            if (encoding == null) {
                input = null;
                output = null;
                try {
                    input = new BufferedInputStream(urlConnection.getInputStream());
                    response.setHeader("Content-Type", mimeType);
                    output = response.getOutputStream();
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
                catch (Exception e) {
                    ButterflyModuleImpl._logger.error("Error processing " + resource, (Throwable)e);
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
            } else {
                input = null;
                output = null;
                try {
                    input = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), encoding));
                    response.setHeader("Content-Type", mimeType + ";charset=" + encoding);
                    response.setCharacterEncoding(encoding);
                    v0 /* !! */  = output = filtering != false ? this.getFilteringWriter(request, response, absolute) : response.getWriter();
                    if (prologue != null) {
                        output.write(prologue);
                    }
                    IOUtils.copy((Reader)input, (Writer)output);
                    if (epilogue == null) ** GOTO lbl47
                    output.write(epilogue);
                }
                catch (Exception e) {
                    ButterflyModuleImpl._logger.error("Error processing " + resource, (Throwable)e);
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
            }
        } else {
            response.sendError(404, "Couldn't find the specified resource");
        }
lbl47:
        // 6 sources

        ButterflyModuleImpl._logger.trace("< send {}", (Object)resource);
        return true;
    }

    public static class Level {
        String name;
        String href;

        public Level(String name, String href) {
            this.name = name;
            this.href = href;
        }

        public String getName() {
            return this.name;
        }

        public String getHref() {
            return this.href;
        }
    }

    class Controller
    implements ContextAction {
        private String _path;
        private HttpServletRequest _request;
        private HttpServletResponse _response;
        private Scriptable _scope;

        public Controller(String path, HttpServletRequest request, HttpServletResponse response) {
            this._path = path;
            this._request = request;
            this._response = response;
        }

        public Object run(org.mozilla.javascript.Context context) {
            ButterflyScope scope;
            try {
                scope = ButterflyModuleImpl.this.getScope(context, this._request);
            }
            catch (Exception e) {
                throw new RuntimeException("Error retrieving scope", e);
            }
            ButterflyModuleImpl.this.initScope(context, (Scriptable)scope);
            return this.process(context, (Scriptable)scope);
        }

        public boolean didRespond() {
            return ((ScriptableButterfly)((Object)this._scope.get("butterfly", this._scope))).didRespond();
        }

        private Object process(org.mozilla.javascript.Context context, Scriptable scope) {
            this._scope = scope;
            Function function = this.getFunction("process", scope, context);
            Object[] args = new Object[]{org.mozilla.javascript.Context.javaToJS((Object)this._path, (Scriptable)scope), org.mozilla.javascript.Context.javaToJS((Object)this._request, (Scriptable)scope), org.mozilla.javascript.Context.javaToJS((Object)this._response, (Scriptable)scope)};
            return function.call(context, scope, scope, args);
        }

        private Function getFunction(String name, Scriptable scope, org.mozilla.javascript.Context ctx) {
            Object fun;
            try {
                fun = ctx.compileString(name, null, 1, null).exec(ctx, scope);
            }
            catch (EcmaError ee) {
                throw new RuntimeException("Function '" + name + "()' not found.");
            }
            if (!(fun instanceof Function)) {
                throw new RuntimeException("'" + name + "' is not a function");
            }
            return (Function)fun;
        }
    }
}

