/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode.ppm;

import com.colloquial.arithcode.ppm.ArithCodeModel;

public final class AdaptiveUnigramModel
implements ArithCodeModel {
    private int[] _count = new int[258];
    private static final int MAX_COUNT = 65536;
    private static final int NUM_BYTES = 256;
    private static final int EOF_INDEX = 256;
    private static final int TOTAL_INDEX = 257;

    public AdaptiveUnigramModel() {
        for (int i = 0; i < 256; ++i) {
            this._count[i] = i;
        }
        this._count[256] = 256;
        this._count[257] = 257;
    }

    @Override
    public void interval(int symbol, int[] result) {
        if (symbol == -1) {
            symbol = 256;
        }
        result[0] = this.lowCount(symbol);
        result[1] = this.highCount(symbol);
        result[2] = this.totalCount();
        this.increment(symbol);
    }

    @Override
    public int pointToSymbol(int midCount) {
        int low = 0;
        int high = 257;
        while (true) {
            int mid;
            if (this._count[mid = (high + low) / 2] > midCount) {
                if (high == mid) {
                    --high;
                    continue;
                }
                high = mid;
                continue;
            }
            if (this._count[mid + 1] > midCount) {
                return mid == 256 ? -1 : mid;
            }
            if (low == mid) {
                ++low;
                continue;
            }
            low = mid;
        }
    }

    public String toString() {
        return "AdaptiveUnigramModel";
    }

    @Override
    public int totalCount() {
        return this._count[257];
    }

    @Override
    public boolean escaped(int symbol) {
        return false;
    }

    @Override
    public void exclude(int i) {
    }

    @Override
    public void increment(int i) {
        while (++i <= 257) {
            int n = i;
            this._count[n] = this._count[n] + 1;
        }
        if (this.totalCount() >= 65536) {
            this.rescale();
        }
    }

    private int lowCount(int i) {
        return this._count[i];
    }

    private int highCount(int i) {
        return this._count[i + 1];
    }

    private void rescale() {
        int i;
        int[] freqs = new int[this._count.length];
        for (i = 1; i < freqs.length; ++i) {
            freqs[i] = (this._count[i] - this._count[i - 1] + 1) / 2;
        }
        for (i = 1; i < this._count.length; ++i) {
            this._count[i] = this._count[i - 1] + freqs[i];
        }
    }
}

