/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.messaging.v51;

import io.netty.channel.Channel;
import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.RoutingContext;
import org.neo4j.bolt.connection.exception.BoltException;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.bolt.connection.netty.impl.handlers.HelloV51ResponseHandler;
import org.neo4j.bolt.connection.netty.impl.handlers.LogoffResponseHandler;
import org.neo4j.bolt.connection.netty.impl.handlers.LogonResponseHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.BoltProtocol;
import org.neo4j.bolt.connection.netty.impl.messaging.MessageFormat;
import org.neo4j.bolt.connection.netty.impl.messaging.MessageHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.request.HelloMessage;
import org.neo4j.bolt.connection.netty.impl.messaging.request.LogoffMessage;
import org.neo4j.bolt.connection.netty.impl.messaging.request.LogonMessage;
import org.neo4j.bolt.connection.netty.impl.messaging.v5.BoltProtocolV5;
import org.neo4j.bolt.connection.netty.impl.messaging.v51.MessageFormatV51;
import org.neo4j.bolt.connection.netty.impl.spi.Connection;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

public class BoltProtocolV51
extends BoltProtocolV5 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(5, 1);
    public static final BoltProtocol INSTANCE = new BoltProtocolV51();

    @Override
    public CompletionStage<Channel> initializeChannel(Channel channel, String userAgent, BoltAgent boltAgent, Map<String, Value> authMap, RoutingContext routingContext, NotificationConfig notificationConfig, Clock clock, CompletableFuture<Long> latestAuthMillisFuture, ValueFactory valueFactory) {
        BoltException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            return CompletableFuture.failedStage((Throwable)exception);
        }
        HelloMessage message = routingContext.isServerRoutingEnabled() ? new HelloMessage(userAgent, null, Collections.emptyMap(), routingContext.toMap(), false, notificationConfig, this.useLegacyNotifications(), valueFactory) : new HelloMessage(userAgent, null, Collections.emptyMap(), null, false, notificationConfig, this.useLegacyNotifications(), valueFactory);
        CompletableFuture<String> helloFuture = new CompletableFuture<String>();
        ChannelAttributes.messageDispatcher(channel).enqueue(new HelloV51ResponseHandler(channel, helloFuture));
        channel.write((Object)message, channel.voidPromise());
        CompletableFuture logonFuture = new CompletableFuture();
        LogonMessage logon = new LogonMessage(authMap, valueFactory);
        ChannelAttributes.messageDispatcher(channel).enqueue(new LogonResponseHandler(logonFuture, channel, clock, latestAuthMillisFuture));
        channel.writeAndFlush((Object)logon, channel.voidPromise());
        return ((CompletableFuture)helloFuture.thenCompose(ignored -> logonFuture)).thenApply(ignored -> channel);
    }

    @Override
    public CompletionStage<Void> logoff(Connection connection, MessageHandler<Void> handler) {
        LogoffMessage logoffMessage = LogoffMessage.INSTANCE;
        CompletableFuture logoffFuture = new CompletableFuture();
        logoffFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary(null);
            }
        });
        LogoffResponseHandler logoffHandler = new LogoffResponseHandler(logoffFuture);
        return connection.write(logoffMessage, logoffHandler);
    }

    @Override
    public CompletionStage<Void> logon(Connection connection, Map<String, Value> authMap, Clock clock, MessageHandler<Void> handler, ValueFactory valueFactory) {
        LogonMessage logonMessage = new LogonMessage(authMap, valueFactory);
        CompletableFuture<Long> logonFuture = new CompletableFuture<Long>();
        logonFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary(null);
            }
        });
        LogonResponseHandler logonHandler = new LogonResponseHandler(logonFuture, null, clock, logonFuture);
        return connection.write(logonMessage, logonHandler);
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV51();
    }
}

