/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.security.point;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.minbox.framework.security.SecurityResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class DefaultSecurityAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    static Logger logger = LoggerFactory.getLogger(DefaultSecurityAuthenticationEntryPoint.class);

    public void commence(HttpServletRequest httpServletRequest, HttpServletResponse response, AuthenticationException e) throws IOException, ServletException {
        logger.error("Unauthorized", (Throwable)e);
        response.setContentType("application/json");
        response.setStatus(HttpStatus.FORBIDDEN.value());
        SecurityResult result = SecurityResult.builder().errorMessage(HttpStatus.UNAUTHORIZED.getReasonPhrase()).errorCode(String.valueOf(HttpStatus.UNAUTHORIZED.value())).build();
        response.getWriter().write(new ObjectMapper().writeValueAsString((Object)response));
    }
}

