/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.oauth.translator;

import java.io.IOException;
import org.minbox.framework.oauth.response.AuthorizationDeniedResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.DefaultThrowableAnalyzer;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestMethodNotSupportedException;

public class DefaultWebResponseExceptionTranslator
implements WebResponseExceptionTranslator {
    private AuthorizationDeniedResponse authorizationDeniedResponse;
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();

    public DefaultWebResponseExceptionTranslator(AuthorizationDeniedResponse authorizationDeniedResponse) {
        this.authorizationDeniedResponse = authorizationDeniedResponse;
    }

    public ResponseEntity<OAuth2Exception> translate(Exception e) throws Exception {
        Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)e);
        OAuth2Exception ase = (OAuth2Exception)this.throwableAnalyzer.getFirstThrowableOfType(OAuth2Exception.class, causeChain);
        if (ase != null) {
            return this.handleOAuth2Exception(ase);
        }
        ase = (AuthenticationException)this.throwableAnalyzer.getFirstThrowableOfType(AuthenticationException.class, causeChain);
        if (ase != null) {
            return this.handleOAuth2Exception(new UnauthorizedException(e.getMessage(), e));
        }
        ase = (AccessDeniedException)this.throwableAnalyzer.getFirstThrowableOfType(AccessDeniedException.class, causeChain);
        if (ase instanceof AccessDeniedException) {
            return this.handleOAuth2Exception(new ForbiddenException(ase.getMessage(), (Throwable)ase));
        }
        ase = (HttpRequestMethodNotSupportedException)this.throwableAnalyzer.getFirstThrowableOfType(HttpRequestMethodNotSupportedException.class, causeChain);
        if (ase instanceof HttpRequestMethodNotSupportedException) {
            return this.handleOAuth2Exception(new MethodNotAllowed(ase.getMessage(), (Throwable)ase));
        }
        return this.handleOAuth2Exception(new ServerErrorException(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), e));
    }

    private ResponseEntity<OAuth2Exception> handleOAuth2Exception(OAuth2Exception e) throws IOException {
        int status = e.getHttpErrorCode();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cache-Control", "no-store");
        headers.set("Pragma", "no-cache");
        if (status == HttpStatus.UNAUTHORIZED.value() || e instanceof InsufficientScopeException) {
            headers.set("WWW-Authenticate", String.format("%s %s", "Bearer", e.getSummary()));
        }
        org.minbox.framework.oauth.exception.OAuth2Exception apiBootOAuth2Exception = new org.minbox.framework.oauth.exception.OAuth2Exception(e.getMessage(), (Throwable)e, this.authorizationDeniedResponse);
        HttpStatus httpStatus = this.authorizationDeniedResponse.getHttpStatus();
        ResponseEntity response = new ResponseEntity((Object)apiBootOAuth2Exception, (MultiValueMap)headers, httpStatus);
        return response;
    }

    private static class ForbiddenException
    extends OAuth2Exception {
        public ForbiddenException(String msg, Throwable t) {
            super(msg, t);
        }

        public String getOAuth2ErrorCode() {
            return HttpStatus.FORBIDDEN.getReasonPhrase();
        }

        public int getHttpErrorCode() {
            return HttpStatus.FORBIDDEN.value();
        }
    }

    private static class ServerErrorException
    extends OAuth2Exception {
        public ServerErrorException(String msg, Throwable t) {
            super(msg, t);
        }

        public String getOAuth2ErrorCode() {
            return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
        }

        public int getHttpErrorCode() {
            return HttpStatus.INTERNAL_SERVER_ERROR.value();
        }
    }

    private static class UnauthorizedException
    extends OAuth2Exception {
        public UnauthorizedException(String msg, Throwable t) {
            super(msg, t);
        }

        public String getOAuth2ErrorCode() {
            return HttpStatus.UNAUTHORIZED.getReasonPhrase();
        }

        public int getHttpErrorCode() {
            return HttpStatus.UNAUTHORIZED.value();
        }
    }

    private static class MethodNotAllowed
    extends OAuth2Exception {
        public MethodNotAllowed(String msg, Throwable t) {
            super(msg, t);
        }

        public String getOAuth2ErrorCode() {
            return HttpStatus.METHOD_NOT_ALLOWED.getReasonPhrase();
        }

        public int getHttpErrorCode() {
            return HttpStatus.METHOD_NOT_ALLOWED.value();
        }
    }
}

