/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.oauth;

import java.util.ArrayList;
import java.util.List;
import org.minbox.framework.oauth.OAuthConfigProperties;
import org.minbox.framework.oauth.grant.DefaultApiBootOauthTokenGranter;
import org.minbox.framework.oauth.grant.OAuth2TokenGranter;
import org.minbox.framework.oauth.services.MinBoxOAuth2TokenServices;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenGranter;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeTokenGranter;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenGranter;
import org.springframework.security.oauth2.provider.password.ResourceOwnerPasswordTokenGranter;
import org.springframework.security.oauth2.provider.refresh.RefreshTokenGranter;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.util.ObjectUtils;

public class AuthorizationServerConfiguration
extends AuthorizationServerConfigurerAdapter {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private AccessTokenConverter accessTokenConverter;
    @Autowired
    private ClientDetailsService clientDetailsService;
    private List<OAuth2TokenGranter> oAuth2TokenGranters;
    @Autowired
    private WebResponseExceptionTranslator webResponseExceptionTranslator;
    @Autowired
    private OAuthConfigProperties authConfigProperties;

    public AuthorizationServerConfiguration(ObjectProvider<List<OAuth2TokenGranter>> objectProvider) {
        this.oAuth2TokenGranters = (List)objectProvider.getIfAvailable();
    }

    public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
        security.passwordEncoder(this.passwordEncoder()).tokenKeyAccess("permitAll()").checkTokenAccess("isAuthenticated()");
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        endpoints.authenticationManager(this.authenticationManager).tokenStore(this.tokenStore).exceptionTranslator(this.webResponseExceptionTranslator).tokenGranter(this.tokenGranter()).accessTokenConverter(this.accessTokenConverter);
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    private TokenGranter tokenGranter() {
        TokenGranter tokenGranter = new TokenGranter(){
            private CompositeTokenGranter delegate;

            public OAuth2AccessToken grant(String grantType, TokenRequest tokenRequest) {
                if (this.delegate == null) {
                    this.delegate = new CompositeTokenGranter(AuthorizationServerConfiguration.this.getDefaultTokenGranters());
                }
                return this.delegate.grant(grantType, tokenRequest);
            }
        };
        return tokenGranter;
    }

    private TokenEnhancer tokenEnhancer() {
        if (this.accessTokenConverter instanceof JwtAccessTokenConverter) {
            return (TokenEnhancer)this.accessTokenConverter;
        }
        return null;
    }

    protected AuthorizationServerTokenServices tokenServices() {
        MinBoxOAuth2TokenServices tokenServices = new MinBoxOAuth2TokenServices();
        tokenServices.setTokenStore(this.tokenStore);
        tokenServices.setSupportRefreshToken(this.authConfigProperties.isSupportRefreshToken());
        tokenServices.setReuseRefreshToken(this.authConfigProperties.isReuseRefreshToken());
        tokenServices.setAlwaysCreateToken(this.authConfigProperties.isAlwaysCreateToken());
        tokenServices.setAccessTokenValiditySeconds(this.authConfigProperties.getAccessTokenValiditySeconds());
        tokenServices.setRefreshTokenValiditySeconds(this.authConfigProperties.getRefreshTokenValiditySeconds());
        tokenServices.setClientDetailsService(this.clientDetailsService);
        tokenServices.setTokenEnhancer(this.tokenEnhancer());
        return tokenServices;
    }

    private AuthorizationCodeServices authorizationCodeServices() {
        return new InMemoryAuthorizationCodeServices();
    }

    private OAuth2RequestFactory requestFactory() {
        return new DefaultOAuth2RequestFactory(this.clientDetailsService);
    }

    private List<TokenGranter> getDefaultTokenGranters() {
        ClientDetailsService clientDetails = this.clientDetailsService;
        AuthorizationServerTokenServices tokenServices = this.tokenServices();
        AuthorizationCodeServices authorizationCodeServices = this.authorizationCodeServices();
        OAuth2RequestFactory requestFactory = this.requestFactory();
        ArrayList<TokenGranter> tokenGranters = new ArrayList<TokenGranter>();
        tokenGranters.add((TokenGranter)new AuthorizationCodeTokenGranter(tokenServices, authorizationCodeServices, clientDetails, requestFactory));
        tokenGranters.add((TokenGranter)new RefreshTokenGranter(tokenServices, clientDetails, requestFactory));
        ImplicitTokenGranter implicit = new ImplicitTokenGranter(tokenServices, clientDetails, requestFactory);
        tokenGranters.add((TokenGranter)implicit);
        tokenGranters.add((TokenGranter)new ClientCredentialsTokenGranter(tokenServices, clientDetails, requestFactory));
        if (this.authenticationManager != null) {
            tokenGranters.add((TokenGranter)new ResourceOwnerPasswordTokenGranter(this.authenticationManager, tokenServices, clientDetails, requestFactory));
        }
        if (!ObjectUtils.isEmpty(this.oAuth2TokenGranters)) {
            this.oAuth2TokenGranters.stream().forEach(oAuth2TokenGranter -> tokenGranters.add((TokenGranter)new DefaultApiBootOauthTokenGranter(tokenServices, this.clientDetailsService, requestFactory, (OAuth2TokenGranter)oAuth2TokenGranter)));
        }
        return tokenGranters;
    }
}

