/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.BasePreparedStatement;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.result.CompleteResult;
import org.mariadb.jdbc.client.result.StreamingResult;
import org.mariadb.jdbc.client.result.UpdatableResult;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.message.server.ErrorPacket;
import org.mariadb.jdbc.message.server.OkPacket;

public interface ClientMessage {
    public int encode(Writer var1, Context var2) throws IOException, SQLException;

    default public int batchUpdateLength() {
        return 0;
    }

    default public String description() {
        return null;
    }

    default public boolean binaryProtocol() {
        return false;
    }

    default public boolean canSkipMeta() {
        return false;
    }

    default public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, Reader reader, Writer writer, Context context, ExceptionFactory exceptionFactory, ReentrantLock lock, boolean traceEnable) throws IOException, SQLException {
        Column[] ci;
        boolean skipMeta;
        boolean canSkipMeta;
        ReadableByteBuf buf = reader.readPacket(true, traceEnable);
        switch (buf.getUnsignedByte()) {
            case 0: {
                return new OkPacket(buf, context);
            }
            case 255: {
                ErrorPacket errorPacket = new ErrorPacket(buf, context);
                throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            case 251: {
                Completion completion;
                buf.skip(1);
                String fileName = buf.readStringNullEnd();
                FileInputStream is = new FileInputStream(fileName);
                try {
                    int len;
                    byte[] fileBuf = new byte[8192];
                    while ((len = ((InputStream)is).read(fileBuf)) > 0) {
                        writer.writeBytes(fileBuf, 0, len);
                        writer.flush();
                    }
                    writer.writeEmptyPacket();
                    completion = this.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, reader, writer, context, exceptionFactory, lock, traceEnable);
                }
                catch (Throwable fileBuf) {
                    try {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable len) {
                            fileBuf.addSuppressed(len);
                        }
                        throw fileBuf;
                    }
                    catch (FileNotFoundException f) {
                        writer.writeEmptyPacket();
                        this.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, reader, writer, context, exceptionFactory, lock, traceEnable);
                        throw exceptionFactory.withSql(this.description()).create("Could not send file : " + f.getMessage(), "HY000", f);
                    }
                }
                ((InputStream)is).close();
                return completion;
            }
        }
        int fieldCount = buf.readIntLengthEncodedNotNull();
        boolean bl = canSkipMeta = context.canSkipMeta() && this.canSkipMeta();
        boolean bl2 = canSkipMeta ? buf.readByte() == 0 : (skipMeta = false);
        if (canSkipMeta && skipMeta) {
            ci = ((BasePreparedStatement)stmt).getMeta();
        } else {
            ci = new Column[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                ci[i] = new ColumnDefinitionPacket(reader.readPacket(false, traceEnable), context.isExtendedInfo());
            }
        }
        if (canSkipMeta && !skipMeta) {
            ((BasePreparedStatement)stmt).updateMeta(ci);
        }
        if (!context.isEofDeprecated()) {
            reader.readPacket(true, traceEnable);
        }
        if (resultSetConcurrency == 1008) {
            return new UpdatableResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
        }
        if (fetchSize != 0) {
            if ((context.getServerStatus() & 8) > 0) {
                context.setServerStatus(context.getServerStatus() - 8);
            }
            return new StreamingResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, fetchSize, lock, resultSetType, closeOnCompletion, traceEnable);
        }
        return new CompleteResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
    }
}

