/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Pattern;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.money.CurrencyUnitDataProvider;
import org.joda.money.DefaultCurrencyUnitDataProvider;
import org.joda.money.IllegalCurrencyException;
import org.joda.money.MoneyUtils;
import org.joda.money.Ser;

public final class CurrencyUnit
implements Comparable<CurrencyUnit>,
Serializable {
    private static final long serialVersionUID = 327835287287L;
    private static final Pattern CODE = Pattern.compile("[A-Z][A-Z][A-Z]");
    private static final ConcurrentMap<String, CurrencyUnit> currenciesByCode = new ConcurrentSkipListMap<String, CurrencyUnit>();
    private static final ConcurrentMap<Integer, CurrencyUnit> currenciesByNumericCode = new ConcurrentHashMap<Integer, CurrencyUnit>();
    private static final ConcurrentMap<String, CurrencyUnit> currenciesByCountry = new ConcurrentSkipListMap<String, CurrencyUnit>();
    public static final CurrencyUnit USD;
    public static final CurrencyUnit EUR;
    public static final CurrencyUnit JPY;
    public static final CurrencyUnit GBP;
    public static final CurrencyUnit CHF;
    public static final CurrencyUnit AUD;
    public static final CurrencyUnit CAD;
    private final String code;
    private final short numericCode;
    private final short decimalPlaces;

    public static synchronized CurrencyUnit registerCurrency(String currencyCode, int numericCurrencyCode, int decimalPlaces, List<String> countryCodes) {
        return CurrencyUnit.registerCurrency(currencyCode, numericCurrencyCode, decimalPlaces, countryCodes, false);
    }

    public static synchronized CurrencyUnit registerCurrency(String currencyCode, int numericCurrencyCode, int decimalPlaces, List<String> countryCodes, boolean force) {
        MoneyUtils.checkNotNull(currencyCode, "Currency code must not be null");
        if (currencyCode.length() != 3) {
            throw new IllegalArgumentException("Invalid string code, must be length 3");
        }
        if (!CODE.matcher(currencyCode).matches()) {
            throw new IllegalArgumentException("Invalid string code, must be ASCII upper-case letters");
        }
        if (numericCurrencyCode < -1 || numericCurrencyCode > 999) {
            throw new IllegalArgumentException("Invalid numeric code");
        }
        if (decimalPlaces < -1 || decimalPlaces > 30) {
            throw new IllegalArgumentException("Invalid number of decimal places");
        }
        MoneyUtils.checkNotNull(countryCodes, "Country codes must not be null");
        CurrencyUnit currency = new CurrencyUnit(currencyCode, (short)numericCurrencyCode, (short)decimalPlaces);
        if (force) {
            currenciesByCode.remove(currencyCode);
            currenciesByNumericCode.remove(numericCurrencyCode);
            for (String countryCode : countryCodes) {
                currenciesByCountry.remove(countryCode);
            }
        } else {
            if (currenciesByCode.containsKey(currencyCode) || currenciesByNumericCode.containsKey(numericCurrencyCode)) {
                throw new IllegalArgumentException("Currency already registered: " + currencyCode);
            }
            for (String countryCode : countryCodes) {
                if (!currenciesByCountry.containsKey(countryCode)) continue;
                throw new IllegalArgumentException("Currency already registered for country: " + countryCode);
            }
        }
        currenciesByCode.putIfAbsent(currencyCode, currency);
        if (numericCurrencyCode >= 0) {
            currenciesByNumericCode.putIfAbsent(numericCurrencyCode, currency);
        }
        for (String countryCode : countryCodes) {
            CurrencyUnit.registerCountry(countryCode, currency);
        }
        return (CurrencyUnit)currenciesByCode.get(currencyCode);
    }

    public static synchronized CurrencyUnit registerCurrency(String currencyCode, int numericCurrencyCode, int decimalPlaces, boolean force) {
        List<String> countryCodes = Collections.emptyList();
        return CurrencyUnit.registerCurrency(currencyCode, numericCurrencyCode, decimalPlaces, countryCodes, force);
    }

    public static synchronized void registerCountry(String countryCode, CurrencyUnit currency) {
        currenciesByCountry.put(countryCode, currency);
    }

    public static List<CurrencyUnit> registeredCurrencies() {
        return new ArrayList<CurrencyUnit>(currenciesByCode.values());
    }

    public static List<String> registeredCountries() {
        return new ArrayList<String>(currenciesByCountry.keySet());
    }

    public static CurrencyUnit of(Currency currency) {
        MoneyUtils.checkNotNull(currency, "Currency must not be null");
        return CurrencyUnit.of(currency.getCurrencyCode());
    }

    @FromString
    public static CurrencyUnit of(String currencyCode) {
        MoneyUtils.checkNotNull(currencyCode, "Currency code must not be null");
        CurrencyUnit currency = (CurrencyUnit)currenciesByCode.get(currencyCode);
        if (currency == null) {
            throw new IllegalCurrencyException("Unknown currency '" + currencyCode + '\'');
        }
        return currency;
    }

    public static CurrencyUnit ofNumericCode(String numericCurrencyCode) {
        MoneyUtils.checkNotNull(numericCurrencyCode, "Currency code must not be null");
        switch (numericCurrencyCode.length()) {
            case 1: {
                return CurrencyUnit.ofNumericCode(numericCurrencyCode.charAt(0) - 48);
            }
            case 2: {
                return CurrencyUnit.ofNumericCode((numericCurrencyCode.charAt(0) - 48) * 10 + numericCurrencyCode.charAt(1) - 48);
            }
            case 3: {
                return CurrencyUnit.ofNumericCode((numericCurrencyCode.charAt(0) - 48) * 100 + (numericCurrencyCode.charAt(1) - 48) * 10 + numericCurrencyCode.charAt(2) - 48);
            }
        }
        throw new IllegalCurrencyException("Unknown currency '" + numericCurrencyCode + '\'');
    }

    public static CurrencyUnit ofNumericCode(int numericCurrencyCode) {
        CurrencyUnit currency = (CurrencyUnit)currenciesByNumericCode.get(numericCurrencyCode);
        if (currency == null) {
            throw new IllegalCurrencyException("Unknown currency '" + numericCurrencyCode + '\'');
        }
        return currency;
    }

    public static CurrencyUnit of(Locale locale) {
        MoneyUtils.checkNotNull(locale, "Locale must not be null");
        CurrencyUnit currency = (CurrencyUnit)currenciesByCountry.get(locale.getCountry());
        if (currency == null) {
            throw new IllegalCurrencyException("No currency found for locale '" + locale + '\'');
        }
        return currency;
    }

    public static CurrencyUnit ofCountry(String countryCode) {
        MoneyUtils.checkNotNull(countryCode, "Country code must not be null");
        CurrencyUnit currency = (CurrencyUnit)currenciesByCountry.get(countryCode);
        if (currency == null) {
            throw new IllegalCurrencyException("No currency found for country '" + countryCode + '\'');
        }
        return currency;
    }

    CurrencyUnit(String code, short numericCode, short decimalPlaces) {
        assert (code != null) : "Joda-Money bug: Currency code must not be null";
        this.code = code;
        this.numericCode = numericCode;
        this.decimalPlaces = decimalPlaces;
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization delegate required");
    }

    private Object writeReplace() {
        return new Ser(67, this);
    }

    public String getCode() {
        return this.code;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public String getNumeric3Code() {
        if (this.numericCode < 0) {
            return "";
        }
        String str = Integer.toString(this.numericCode);
        if (str.length() == 1) {
            return "00" + str;
        }
        if (str.length() == 2) {
            return "0" + str;
        }
        return str;
    }

    public Set<String> getCountryCodes() {
        HashSet<String> countryCodes = new HashSet<String>();
        for (Map.Entry entry : currenciesByCountry.entrySet()) {
            if (!this.equals(entry.getValue())) continue;
            countryCodes.add((String)entry.getKey());
        }
        return countryCodes;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces < 0 ? (short)0 : this.decimalPlaces;
    }

    public boolean isPseudoCurrency() {
        return this.decimalPlaces < 0;
    }

    public String getSymbol() {
        if ("XXX".equals(this.code)) {
            return this.code;
        }
        try {
            return Currency.getInstance(this.code).getSymbol();
        }
        catch (IllegalArgumentException ex) {
            return this.code;
        }
    }

    public String getSymbol(Locale locale) {
        MoneyUtils.checkNotNull(locale, "Locale must not be null");
        if ("XXX".equals(this.code)) {
            return this.code;
        }
        try {
            return Currency.getInstance(this.code).getSymbol(locale);
        }
        catch (IllegalArgumentException ex) {
            return this.code;
        }
    }

    public Currency toCurrency() {
        return Currency.getInstance(this.code);
    }

    @Override
    public int compareTo(CurrencyUnit other) {
        return this.code.compareTo(other.code);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CurrencyUnit) {
            return this.code.equals(((CurrencyUnit)obj).code);
        }
        return false;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    @ToString
    public String toString() {
        return this.code;
    }

    static {
        try {
            try {
                String clsName = System.getProperty("org.joda.money.CurrencyUnitDataProvider", "org.joda.money.DefaultCurrencyUnitDataProvider");
                Class<CurrencyUnitDataProvider> cls = CurrencyUnit.class.getClassLoader().loadClass(clsName).asSubclass(CurrencyUnitDataProvider.class);
                cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).registerCurrencies();
            }
            catch (SecurityException ex) {
                new DefaultCurrencyUnitDataProvider().registerCurrencies();
            }
        }
        catch (RuntimeException ex) {
            System.err.println("ERROR: " + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            System.err.println("ERROR: " + ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException(ex.toString(), ex);
        }
        USD = CurrencyUnit.of("USD");
        EUR = CurrencyUnit.of("EUR");
        JPY = CurrencyUnit.of("JPY");
        GBP = CurrencyUnit.of("GBP");
        CHF = CurrencyUnit.of("CHF");
        AUD = CurrencyUnit.of("AUD");
        CAD = CurrencyUnit.of("CAD");
    }
}

