/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.AbstractInputPngStream;
import org.jetbrains.letsPlot.util.pngj.BufferedStreamFeeder;
import org.jetbrains.letsPlot.util.pngj.ChunkSeqReaderPng;
import org.jetbrains.letsPlot.util.pngj.InputPngStream;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0006\u0010\u0018\u001a\u00020\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/PngReaderFilter;", "Lorg/jetbrains/letsPlot/util/pngj/AbstractInputPngStream;", "arg0", "Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;", "(Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;)V", "chunksList", "", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "getChunksList", "()Ljava/util/List;", "chunkseq", "Lorg/jetbrains/letsPlot/util/pngj/ChunkSeqReaderPng;", "getChunkseq", "()Lorg/jetbrains/letsPlot/util/pngj/ChunkSeqReaderPng;", "close", "", "createChunkSequenceReader", "read", "", "outBuffer", "", "b", "off", "len", "readUntilEndAndClose", "plot-api"})
public final class PngReaderFilter
extends AbstractInputPngStream {
    @NotNull
    private final ChunkSeqReaderPng chunkseq;

    public PngReaderFilter(@NotNull InputPngStream arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        super(arg0);
        this.chunkseq = this.createChunkSequenceReader();
    }

    @NotNull
    public final ChunkSeqReaderPng getChunkseq() {
        return this.chunkseq;
    }

    @NotNull
    protected final ChunkSeqReaderPng createChunkSequenceReader() {
        return new ChunkSeqReaderPng(){

            public boolean shouldSkipContent(int len, @NotNull String id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return super.shouldSkipContent(len, id) || Intrinsics.areEqual((Object)id, (Object)"IDAT");
            }

            protected boolean shouldCheckCrc(int len, @Nullable String id) {
                return false;
            }
        };
    }

    @Override
    public void close() {
        super.close();
        this.chunkseq.close();
    }

    @Override
    public int read() {
        int r = super.read();
        if (r > 0) {
            byte[] byArray = new byte[]{(byte)r};
            this.chunkseq.feedAll(byArray, 0, 1);
        }
        return r;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int res = super.read(b, off, len);
        if (res > 0) {
            this.chunkseq.feedAll(b, off, res);
        }
        return res;
    }

    @Override
    public int read(@NotNull byte[] outBuffer) {
        Intrinsics.checkNotNullParameter((Object)outBuffer, (String)"outBuffer");
        int res = super.read(outBuffer);
        if (res > 0) {
            this.chunkseq.feedAll(outBuffer, 0, res);
        }
        return res;
    }

    public final void readUntilEndAndClose() {
        BufferedStreamFeeder br = new BufferedStreamFeeder(this.getStream(), 0, 2, null);
        while (!this.chunkseq.isDone() && br.hasPendingBytes() && br.feed(this.chunkseq) >= 1) {
        }
        br.close();
        this.close();
    }

    @NotNull
    public final List<PngChunk> getChunksList() {
        return this.chunkseq.getChunks();
    }
}

