/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationUnitKt__DurationUnitJvmKt;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=5, xi=49, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001c\u0010\u0000\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u001a\u0014\u0010\u0007\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\u0010\u0010\b\u001a\u00020\t*\u00060\u0001j\u0002`\u0002H\u0001\u00a8\u0006\n"}, d2={"durationUnitByIsoChar", "Ljava/util/concurrent/TimeUnit;", "Lkotlin/time/DurationUnit;", "isoChar", "", "isTimeComponent", "", "durationUnitByShortName", "shortName", "", "kotlin-stdlib"}, xs="kotlin/time/DurationUnitKt")
class DurationUnitKt__DurationUnitKt
extends DurationUnitKt__DurationUnitJvmKt {
    @SinceKotlin(version="1.3")
    @ExperimentalTime
    @NotNull
    public static final String shortName(@NotNull TimeUnit $this$shortName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$shortName, "<this>");
        TimeUnit timeUnit = $this$shortName;
        int n = WhenMappings.$EnumSwitchMapping$0[timeUnit.ordinal()];
        switch (n) {
            case 1: {
                string = "ns";
                break;
            }
            case 2: {
                string = "us";
                break;
            }
            case 3: {
                string = "ms";
                break;
            }
            case 4: {
                string = "s";
                break;
            }
            case 5: {
                string = "m";
                break;
            }
            case 6: {
                string = "h";
                break;
            }
            case 7: {
                string = "d";
                break;
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus("Unknown unit: ", (Object)$this$shortName).toString());
            }
        }
        return string;
    }

    @SinceKotlin(version="1.5")
    @ExperimentalTime
    @NotNull
    public static final TimeUnit durationUnitByShortName(@NotNull String shortName) {
        TimeUnit timeUnit;
        Intrinsics.checkNotNullParameter(shortName, "shortName");
        switch (shortName) {
            case "ns": {
                timeUnit = TimeUnit.NANOSECONDS;
                break;
            }
            case "us": {
                timeUnit = TimeUnit.MICROSECONDS;
                break;
            }
            case "ms": {
                timeUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case "s": {
                timeUnit = TimeUnit.SECONDS;
                break;
            }
            case "m": {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case "h": {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case "d": {
                timeUnit = TimeUnit.DAYS;
                break;
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus("Unknown duration unit short name: ", shortName));
            }
        }
        return timeUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SinceKotlin(version="1.5")
    @ExperimentalTime
    @NotNull
    public static final TimeUnit durationUnitByIsoChar(char isoChar, boolean isTimeComponent) {
        TimeUnit timeUnit;
        if (!isTimeComponent) {
            char c = isoChar;
            if (c != 'D') throw new IllegalArgumentException(Intrinsics.stringPlus("Invalid or unsupported duration ISO non-time unit: ", Character.valueOf(isoChar)));
            timeUnit = TimeUnit.DAYS;
            return timeUnit;
        } else {
            char c = isoChar;
            if (c == 'H') {
                timeUnit = TimeUnit.HOURS;
                return timeUnit;
            } else if (c == 'M') {
                timeUnit = TimeUnit.MINUTES;
                return timeUnit;
            } else {
                if (c != 'S') throw new IllegalArgumentException(Intrinsics.stringPlus("Invalid duration ISO time unit: ", Character.valueOf(isoChar)));
                timeUnit = TimeUnit.SECONDS;
            }
        }
        return timeUnit;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimeUnit.values().length];
            nArray[TimeUnit.NANOSECONDS.ordinal()] = 1;
            nArray[TimeUnit.MICROSECONDS.ordinal()] = 2;
            nArray[TimeUnit.MILLISECONDS.ordinal()] = 3;
            nArray[TimeUnit.SECONDS.ordinal()] = 4;
            nArray[TimeUnit.MINUTES.ordinal()] = 5;
            nArray[TimeUnit.HOURS.ordinal()] = 6;
            nArray[TimeUnit.DAYS.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

