/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.common;

import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.sys.env.EnvUtil;
import io.jsonwebtoken.io.Decoders;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthConfigs {
    @JustForTest
    private static Boolean cachingEnabled = null;
    @Value(value="${nacos.core.auth.default.token.secret.key:}")
    private String secretKey;
    private byte[] secretKeyBytes;
    @Value(value="${nacos.core.auth.default.token.expire.seconds:18000}")
    private long tokenValidityInSeconds;
    @Value(value="${nacos.core.auth.system.type:}")
    private String nacosAuthSystemType;
    @Value(value="${nacos.core.auth.server.identity.key:}")
    private String serverIdentityKey;
    @Value(value="${nacos.core.auth.server.identity.value:}")
    private String serverIdentityValue;
    @Value(value="${nacos.core.auth.enable.userAgentAuthWhite:true}")
    private boolean enableUserAgentAuthWhite;

    public byte[] getSecretKeyBytes() {
        if (this.secretKeyBytes == null) {
            this.secretKeyBytes = (byte[])Decoders.BASE64.decode((Object)this.secretKey);
        }
        return this.secretKeyBytes;
    }

    public long getTokenValidityInSeconds() {
        return this.tokenValidityInSeconds;
    }

    public String getNacosAuthSystemType() {
        return this.nacosAuthSystemType;
    }

    public String getServerIdentityKey() {
        return this.serverIdentityKey;
    }

    public String getServerIdentityValue() {
        return this.serverIdentityValue;
    }

    public boolean isEnableUserAgentAuthWhite() {
        return this.enableUserAgentAuthWhite;
    }

    public boolean isAuthEnabled() {
        String enabled = System.getProperty("nacos.core.auth.enabled");
        if (StringUtils.isNotBlank((CharSequence)enabled)) {
            return BooleanUtils.toBoolean((String)enabled);
        }
        return BooleanUtils.toBoolean((String)EnvUtil.getProperty((String)"nacos.core.auth.enabled", (String)"false"));
    }

    public boolean isCachingEnabled() {
        if (Objects.nonNull(cachingEnabled)) {
            return cachingEnabled;
        }
        return BooleanUtils.toBoolean((String)EnvUtil.getProperty((String)"nacos.core.auth.caching.enabled", (String)"true"));
    }

    @JustForTest
    public static void setCachingEnabled(boolean cachingEnabled) {
        AuthConfigs.cachingEnabled = cachingEnabled;
    }
}

