/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jasig.cas.client.tomcat.CasRealm;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesCasRealmDelegate
implements CasRealm {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String propertiesFilePath;
    private Map<String, Set<String>> roleMap;

    public void setPropertiesFilePath(String path) {
        this.propertiesFilePath = path;
    }

    public void readProperties() {
        CommonUtils.assertNotNull((Object)this.propertiesFilePath, (String)"PropertiesFilePath not set.");
        File file = new File(this.propertiesFilePath);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.propertiesFilePath);
        }
        CommonUtils.assertTrue((boolean)file.exists(), (String)("File not found " + file));
        CommonUtils.assertTrue((boolean)file.canRead(), (String)("Cannot read " + file));
        this.logger.debug("Loading users/roles from {}", (Object)file);
        Properties properties = new Properties();
        try {
            properties.load(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error loading users/roles from " + file, e);
        }
        this.roleMap = new HashMap<String, Set<String>>(properties.size());
        for (Object key : properties.keySet()) {
            String user = (String)key;
            HashSet<String> roleSet = new HashSet<String>();
            String[] roles = properties.getProperty(user).split(",\\s*");
            roleSet.addAll(Arrays.asList(roles));
            this.roleMap.put(user, roleSet);
        }
    }

    @Override
    public Principal authenticate(Principal p) {
        if (this.roleMap.containsKey(p.getName())) {
            return p;
        }
        return null;
    }

    @Override
    public String[] getRoles(Principal p) {
        Set<String> roleSet = this.roleMap.get(p.getName());
        return roleSet.toArray(new String[roleSet.size()]);
    }

    @Override
    public boolean hasRole(Principal principal, String role) {
        if ("*".equals(role)) {
            return true;
        }
        Set<String> roles = this.roleMap.get(principal.getName());
        return roles != null && roles.contains(role);
    }
}

