/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component(value="bindModeSearchDatabaseAuthenticationHandler")
public class BindModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        HandlerResult handlerResult;
        block7: {
            if (this.getDataSource() == null) {
                throw new GeneralSecurityException("Authentication handler is not configured correctly");
            }
            Connection connection = null;
            try {
                String username = credential.getUsername();
                String password = this.getPasswordEncoder().encode(credential.getPassword());
                connection = this.getDataSource().getConnection(username, password);
                handlerResult = this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
                if (connection == null) break block7;
            }
            catch (SQLException e) {
                try {
                    throw new FailedLoginException(e.getMessage());
                    catch (Exception e2) {
                        throw new PreventedException("Unexpected SQL connection error", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        DataSourceUtils.releaseConnection(connection, (DataSource)this.getDataSource());
                    }
                    throw throwable;
                }
            }
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.getDataSource());
        }
        return handlerResult;
    }

    @Override
    @Autowired(required=false)
    public void setDataSource(@Qualifier(value="bindSearchDatabaseDataSource") DataSource dataSource) {
        super.setDataSource(dataSource);
    }
}

